<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
 */

// ---------------- AuthController----------------------------------------------------------------------
Route::post('login', 'Api\AuthController@login')->name('login');
Route::post('registration', 'Api\AuthController@registration')->name('registration');
Route::post('profile', 'Api\AuthController@profile')->name('profile');
Route::post('update_profile', 'Api\AuthController@update_profile')->name('update_profile');
Route::post('forgot_password', 'Api\AuthController@forgot_password')->name('forgot_password');
Route::post('password_change', 'Api\AuthController@password_change')->name('password_change');
Route::post('loginwithotp', 'Api\AuthController@loginwithotp')->name('loginwithotp');
Route::post('RecentQuizByUser', 'Api\AuthController@RecentQuizByUser')->name('RecentQuizByUser');

// ---------------- QuestionController----------------------------------------------------------------------
Route::post('question_by_level_master', 'Api\QuestionController@question_by_level_master')->name('question_by_level_master');
Route::post('question_by_level', 'Api\QuestionController@question_by_level_id')->name('question_by_level_id');
Route::post('question_by_contest', 'Api\QuestionController@question_by_contest_id')->name('question_by_contest_id');
Route::post('save_question_report', 'Api\QuestionController@save_question_report')->name('save_question_report');
Route::post('save_Practice_Question_Report', 'Api\QuestionController@save_Practice_Question_Report')->name('save_Practice_Question_Report');
Route::post('save_contest_question_report', 'Api\QuestionController@save_contest_question_report')->name('save_contest_question_report');

// ---------------- Genaral_Setting_Controller----------------------------------------------------------------------
Route::post('general_setting', 'Api\Genaral_Setting_Controller@genaral_setting')->name('genaral_setting');
Route::post('earn_point', 'Api\Genaral_Setting_Controller@earn_point')->name('earn_point');
Route::post('checkStatus', 'Api\Genaral_Setting_Controller@checkStatus')->name('checkStatus');

// ---------------- Transaction_Controller----------------------------------------------------------------------
Route::post('get_transaction', 'Api\Transaction_Controller@get_transaction')->name('get_transaction');
Route::post('withdrawal_list', 'Api\Transaction_Controller@withdrawal_list')->name('withdrawal_list');
Route::post('withdrawal_request', 'Api\Transaction_Controller@withdrawal_request')->name('withdrawal_request');
Route::post('reward_points', 'Api\Transaction_Controller@reward_points')->name('reward_points');
Route::post('refer_transaction', 'Api\Transaction_Controller@refer_transaction')->name('refer_transaction');
Route::post('get_earn_transaction', 'Api\Transaction_Controller@get_earn_transaction')->name('get_earn_transaction');
Route::post('get_reward_points', 'Api\Transaction_Controller@get_reward_points')->name('get_reward_points');
Route::get('get_packages', 'Api\Transaction_Controller@get_packages')->name('get_packages');
Route::post('add_transaction', 'Api\Transaction_Controller@add_transaction')->name('add_transaction');
Route::post('get_package_transaction', 'Api\Transaction_Controller@get_package_transaction')->name('get_package_transaction');

// ---------------- Level_Controller----------------------------------------------------------------------
Route::post('get_level', 'Api\Level_Controller@get_level')->name('get_level');
Route::post('get_pratice_level', 'Api\Level_Controller@get_pratice_level')->name('get_pratice_level');
Route::post('get_category', 'Api\Level_Controller@category')->name('category');
Route::post('getQuestionLevelMaster', 'Api\Level_Controller@getQuestionLevelMaster')->name('getQuestionLevelMaster');
Route::post('getCategoryByLevelMaster', 'Api\Level_Controller@getCategoryByLevelMaster')->name('getCategoryByLevelMaster');
Route::post('getLavelByCategoryId', 'Api\Level_Controller@getLavelByCategoryId')->name('getLavelByCategoryId');

// ---------------- Practice_Question_Controller----------------------------------------------------------------------
Route::post('getPracticeQuestionByLavel', 'Api\Practice_Question_Controller@getPracticeQuestionByLavel')->name('getPracticeQuestionByLavel');
Route::post('getPracticeLavelByCategoryId', 'Api\Practice_Question_Controller@getPracticeLavelByCategoryId')->name('getPracticeLavelByCategoryId');

// ---------------- Notification_Controller----------------------------------------------------------------------
Route::post('get_notification', 'Api\Notification_Controller@get_notification')->name('get_notification');
Route::post('read_notification', 'Api\Notification_Controller@read_notification')->name('read_notification');

// ---------------- Leaderboard_Controller----------------------------------------------------------------------
Route::post('getTodayLeaderBoard', 'Api\Leaderboard_Controller@getTodayLeaderBoard')->name('getTodayLeaderBoard');
Route::post('getLeaderBoard', 'Api\Leaderboard_Controller@getLeaderBoard')->name('getLeaderBoard');
Route::post('getPractiseLeaderBoard', 'Api\Leaderboard_Controller@getPractiseLeaderBoard')->name('getPractiseLeaderBoard');
Route::post('getTodayContestLeaderBoard', 'Api\Leaderboard_Controller@getTodayContestLeaderBoard')->name('getTodayContestLeaderBoard');

// ---------------- Contest_Controllerler----------------------------------------------------------------------
Route::post('getContest', 'Api\Contest_Controller@getContest')->name('getContest');
Route::post('getContestLeaderBoard', 'Api\Contest_Controller@getContestLeaderBoard')->name('getContestLeaderBoard');
Route::post('joinContest', 'Api\Contest_Controller@joinContest')->name('joinContest');
Route::post('upcomingContest', 'Api\Contest_Controller@upcomingContest')->name('upcomingContest');
Route::post('get_review_question_by_contest_id', 'Api\Contest_Controller@get_review_question_by_contest_id')->name('get_review_question_by_contest_id');
Route::post('get_winner_by_contest', 'Api\Contest_Controller@get_winner_by_contest')->name('get_winner_by_contest');
