@extends('admin.layouts.master')
@section('title',  __('Label.Edit Subscription'))
@section('content')
  	
		<!-- Start: Body-Content -->
      	<div class="body-content">
      		<!-- mobile title -->
      		<h1 class="page-title-sm">@yield('title')</h1>

      		<div class="border-bottom row mb-3">
      			<div class="col-sm-10">
      				<ol class="breadcrumb">
      					<li class="breadcrumb-item">
      						<a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
      					</li>
      					<li class="breadcrumb-item">
      						<a href="{{ route('subscription') }}">{{__('Label.Subscription')}}</a>
      					</li>
      					<li class="breadcrumb-item active" aria-current="page">
      						{{__('Label.Edit Subscription')}}
      					</li>
      				</ol>
      			</div>
      			<div class="col-sm-2 d-flex align-items-center">
      				<a href="{{ route('subscription') }}"class="btn btn-default mw-120"style="margin-top:-14px">{{__('Label.Subscription')}}</a>
      			</div>
      		</div>

      		<div class="card custom-border-card mt-3">
      			<form enctype="multipart/form-data" id="save_edit_subscription">
      				{!! csrf_field() !!}
      				<div class="form-row">
      					<div class="col-md-12 mb-3">
      						<div class="form-group">
      							<label for="name">{{__('Label.NAME')}}</label>
      							<input name="name" type="text" class="form-control" id="name" placeholder="Enter name" value="{{$result->name}}">
      						</div>
      					</div>
      				</div>
      				<div class="form-row">
      					<div class="col-md-6 mb-3">
      						<div class="form-group">
      							<label for="price">{{__('Label.PRICE')}}</label>
      							<input name="price" type="number" class="form-control" id="price" placeholder="Enter Price" value="{{$result->price}}">
      						</div>
      					</div>
      					<div class="col-md-6 mb-3">
      						<div class="form-group">
      							<label for="currency_type">{{__('Label.TYPE')}}</label>
      							<input name="currency_type"type="text"class="form-control" id="currency_type" readonly value="{{ $result->currency_type ?? '' }}" >
      						</div>
      					</div>
      				</div>
      				<div class="form-row">
      					<div class="col-md-6 mb-3">
      						<div class="form-group">
      							<label for="coin">{{__('Label.COIN')}}</label>
      							<input name="coin" type="number" class="form-control" id="coin" placeholder="Ex.1" value="{{$result->coin}}">
      						</div>
      					</div>
      					<div class="col-md-6 mb-3">
      						<div class="form-group">
      							<label for="product_package">{{__('Label.PRODUCT PACKAGE')}}</label>
      							<input name="product_package" type="text" class="form-control" id="product_package" placeholder="Enter Product package" value="{{$result->product_package}}">
      						</div>
      					</div>
      				</div>
      				<div class="form-row">
      					<div class="col-md-6 mb-3">
      						<div class="form-group">
      							<label for="image">{{__('Label.IMAGE')}}</label>
      							<input type="file" class="form-control" id="image" name="image" value="{{$result->image}}">
      							<label class="mt-1">{{__('Label.Note_Image')}}</label>
      						</div>
      					</div>
      					<div class="col-md-6 mb-3">
      						<div class="custom-file ml-5">
								<?php 
									if ($result->image){
										$app = URL::asset('/images/subscription').'/'.$result->image;
									} else{
										$app = asset('assets/imgs/1.png');
									}
                  					?>
      							<img  src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
      							<input type="hidden" name="old_image" value="{{$result->image}}">
      						</div>
      					</div>
      				</div>
      				<div class="border-top mt-2 pt-3">
      					<input type="hidden" value="{{$result->id}}" name="id">
      					<button type="button" class="btn btn-default mw-120" onclick="save_edit_subscription()">{{__('Label.UPDATE')}}</button>
      					<a href="{{route('subscription')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
      				</div>
      			</form>
      		</div>
      	</div>
      	<!-- End: Body-Content -->
    </div>
    <!-- End: Right Contenct -->
@endsection

@push('scripts')
    <script type="text/javascript">

    	function save_edit_subscription(){
		$("#dvloader").show();
    		var formData = new FormData($("#save_edit_subscription")[0]);
    		$.ajax({
    			type:'POST',
    			url:'{{ route("subscriptionUpdate") }}',
    			data:formData,
    			cache:false,
    			contentType: false,
    			processData: false,
    			success:function(resp){
				$("#dvloader").hide();
                    get_responce_message(resp, 'save_edit_subscription', '{{ route("subscription") }}');
    			},
    			error: function(XMLHttpRequest, textStatus, errorThrown) {
    				$("#dvloader").hide();
    				toastr.error(errorThrown.msg,'failed');         
    			}
    		});
    	}
    </script>
@endpush