@extends('admin.layouts.master')
@section('title', __('Label.Contest Question'))
@section('content')
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Label.Contest Question')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('contestquestionAdd') }}" class="btn btn-default mw-150" style="margin-top: -14px;">{{__('Label.Add Contest Question')}}</a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped contestquestion-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
              <th> {{__('Label.Question')}} </th>
              <th width="20px"> {{__('Label.Question  Image')}}</th>
              <th> {{__('Label.Category')}} </th>
              <th> {{__('Label.Option A')}} </th>
              <th> {{__('Label.Option B')}} </th>
              <th> {{__('Label.Option C')}} </th>
              <th> {{__('Label.Option D')}} </th>
              <th> {{__('Label.Answer')}} </th>
              <th width="60px"> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.contestquestion-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          order: [ [0, 'asc'] ],
          ajax: "{{ route('contestquestionData') }}",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'question', name:'question'},
          { data: 'image', name: 'image', 
            "render": function (data, type, full, meta) {
              if(data) {
                return "<img src='{{url('images/question/')}}/"+ data + "' height=50 width=50/>";
              } else {
                return "<img src='{{url('assets/imgs/1.png')}}' height=50 />";
              }
            },
          },
          {data: 'category.name', name: 'name',
            "render": function (data, type, full, meta) {
              if(data) {
                return data;
              } else {
                return "-";
              }
            },
          },
          {data: 'option_a', name: 'option_a'},
          {data: 'option_b', name: 'option_b'},
          {data: 'option_c', name: 'option_c',
            "render": function (data, type, full, meta) {
            if (data) {
              return data;
            } else {
              return "-";
            }
            },
          },
          {data: 'option_d', name: 'option_d',
            "render": function (data, type, full, meta) {
            if (data) {
              return data;
            } else {
              return "-";
            }
            },
          },
          { data: 'answer', name: 'answer', 
            "render": function (data, type, full, meta) {

              if (data == 1) {
                return "A";
              } else if(data == 2){
                return "B";
              } else if(data == 3){
                return "C";
              } else if(data == 4){
                return "D";
              }

            },
          }, 
          {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
@endpush
