@extends('admin.layouts.master')
@section('title',  __('Label.Add Classification'))
@section('content')
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item">
              <a href="{{ route('classification') }}">{{__('Label.Classification')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
               {{__('Label.Add Classification')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('classification') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.Classification')}}</a>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
        <form id="save_classification">
          {!! csrf_field() !!}
          <div class="form-row">
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label for="level_name">{{__('Label.NAME')}}</label>
                <input name="level_name" type="text" class="form-control" id="level_name" placeholder="{{__('Label.Please Enter Name')}}">
              </div>
            </div>
          </div>
          <div class="form-row">
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label for="level_order">{{__('Label.LEVEL ORDER NO')}}</label>
                <input name="level_order" type="number" class="form-control" id="level_order" placeholder="{{__('Label.Enter Level Order')}}">
              </div>
            </div>
          </div>
          <div class="border-top mt-2 pt-3">
           <button type="button" class="btn btn-default mw-120" onclick="save_classification()">{{__('Label.SAVE')}}</button>
           <a href="{{route('classification')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
         </div>
       </form>
     </div>
   </div>
   <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
	<script type="text/javascript">

    function save_classification(){
      $("#dvloader").show();
      var formData = new FormData($("#save_classification")[0]);
      $.ajax({
        type:'POST',
        url:'{{ route("classificationSave") }}',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_classification', '{{ route("classification") }}');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
          toastr.error(errorThrown.msg,'failed');         
        }
      });
    }
  </script>
@endpush