<?php

namespace App\Http\Controllers\Api;

use Validator;
use App\Models\Users;
use App\Models\Contest;
use App\Models\Withdrawal;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\Earn_transaction;
use App\Models\Subscription_Plan;
use App\Models\Wallet_Transaction;
use App\Models\Reward_Transaction;
use App\Http\Controllers\Controller;
use App\Models\Refer_Earn_Transaction;

class Transaction_Controller extends Controller
{
    public function get_transaction(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Wallet_Transaction::select('wallet_transaction.*', 'contest_master.name as contest_name')
                    ->join('contest_master', 'wallet_transaction.contest_id', '=', 'contest_master.id')
                    ->where('user_id', $request->user_id)
                    ->get();

                if (count($data)) {
                    $withdrawal['status'] = 200;
                    $withdrawal['message'] = __('api_msg.get_record_successfully');
                    $withdrawal['result'] = $data;
                    return $withdrawal;
                } else {
                    $msg['status'] = 400;
                    $msg['message'] = __('api_msg.record_not_found');
                    $msg['result'] = [];
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function withdrawal_list(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);

            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Withdrawal::where('user_id', $request->user_id)->get();
                if (count($data)) {
                    $withdrawal['status'] = 200;
                    $withdrawal['message'] = __('api_msg.get_record_successfully');
                    $withdrawal['result'] = $data;
                    return $withdrawal;
                } else {
                    $msg['status'] = 400;
                    $msg['message'] = __('api_msg.record_not_found');
                    $msg['result'] = [];
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function withdrawal_request(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'payment_detail' => 'required',
                'payment_type' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Users::where('id', $request->user_id)->first();
                if ($data) {

                    if ($data->total_points >= 15000) {
                        $withdrawal_req = new Withdrawal();
                        $withdrawal_req->user_id = $request->user_id;
                        $withdrawal_req->point = $data->total_points;
                        $withdrawal_req->total_amount = $data->total_points / 15000;
                        $withdrawal_req->payment_type = $request->payment_type;
                        $withdrawal_req->payment_detail = $request->payment_detail;
                        $withdrawal_req->status = 0;
                        $withdrawal_req->save();
                        $data->total_points = 0;
                        $data->save();

                        $withdrawal_request['status'] = 200;
                        $withdrawal_request['message'] = __('api_msg.your_withdrawal_request_successfully_added');
                        $withdrawal_request['result'] = $data;
                        return $withdrawal_request;
                    } else {
                        $msg['status'] = 201;
                        $msg['message'] = __('api_msg.your_earning_points_not_more_than_15000');
                        return $msg;
                    }
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.record_not_found');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function reward_points(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'reward_points' => 'required',
                'type' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $user = new Reward_Transaction();
                $user->user_id = $request->user_id;
                $user->reward_points = $request->reward_points;
                if ($request->type == '1') {
                    $user->type = '1';
                } else {
                    $user->type = '0';
                }
                if ($user->save()) {
                    $user_data = Users::where('id', $user->user_id)->first();
                    if ($user_data) {
                        $sum = $user_data->total_points + $request->reward_points;
                        $user_data->total_points = $sum;
                        $user_data->save();
                    }
                    $data['status'] = 200;
                    $data['message'] = __('api_msg.points_rewarded_successfully');
                    return $data;
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.points_not_save');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function refer_transaction(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Refer_Earn_Transaction::select('*')
                    ->where('parent_user_id', $request->user_id)
                    ->with('users')
                    ->get();
                if (count($data)) {
                    for ($i = 0; $i < count($data); $i++) {

                        $result['refered_point'] = $data[$i]->child_user_earned_point;
                        $result['refered_date'] = $data[$i]->refered_date;
                        $result['reference_code'] = $data[$i]->parent_user_id;
                        if ($data[$i]->users) {
                            $result['user_name'] = $data[$i]->users->username;
                            $result['email'] = $data[$i]->users->email;
                            $result['profile_img'] = $data[$i]->users->profile_img;
                            $result['mobile_number'] = $data[$i]->users->mobile_number;
                        } else {
                            $result['user_name'] = "";
                            $result['email'] = "";
                            $result['profile_img'] = "";
                            $result['mobile_number'] = "";
                        }
                        $store[] = $result;
                    }
                    $Result['status'] = 200;
                    $Result['message'] = __('api_msg.get_record_successfully');
                    $Result['result'] = $store;
                    return $Result;
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.record_not_found');
                    $msg['result'] = [];
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function get_earn_transaction(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Earn_transaction::select('id', 'user_id', 'contest_id', 'type', 'point', 'created_at')
                    ->where('user_id', $request->user_id)
                    ->get();

                if ($data) {
                    // Find Contest
                    for ($i = 0; $i < count($data); $i++) {
                        if ($data[$i]->type == 1) {
                            $ContestName = Contest::where('id', $data[$i]->contest_id)->first();
                            $data[$i]->contest_name = $ContestName->name;
                        } else {
                            $data[$i]->contest_name = "Quiz";
                        }
                    }
                    $withdrawal['status'] = 200;
                    $withdrawal['message'] = __('api_msg.get_record_successfully');
                    $withdrawal['result'] = $data;
                    return $withdrawal;
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = [];
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function get_reward_points(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Reward_Transaction::select('*')
                    ->where('user_id', $request->user_id)
                    ->get();

                if ($data != null) {

                    foreach ($data as $row) {
                        $row->type_name = 'Daily';
                        if ($row->type == 1) {
                            $row->type_name = 'Spin to win';
                        }
                    }
                    // Find Contest
                    $withdrawal['status'] = 200;
                    $withdrawal['message'] = __('api_msg.get_record_successfully');
                    $withdrawal['result'] = $data;
                    return $withdrawal;
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.record_not_found');
                    $msg['result'] = [];
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function get_packages(Request $request)
    {
        try {
            $data = Subscription_Plan::get();
            if ($data) {
                for ($i = 0; $i < count($data); $i++) {
                    if ($data[$i]->image) {
                        $path = url('images/subscription/' . $data[$i]->image);
                        $data[$i]->image = $path;
                    } else {
                        $data[$i]->image = "";
                    }
                }
                $withdrawal['status'] = 200;
                $withdrawal['message'] = __('api_msg.get_record_successfully');
                $withdrawal['result'] = $data;
                return $withdrawal;
            } else {
                $msg['status'] = 200;
                $msg['message'] = __('api_msg.get_record_successfully');
                $msg['result'] = [];
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function add_transaction(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'plan_subscription_id' => 'required',
                'coin' => 'required',
                'transaction_amount' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                if ($request->transaction_id) {
                    $transaction_id = $request->transaction_id;
                } else {
                    $transaction_id = "";
                }

                $data = new Transaction();
                $data->user_id = $request->user_id;
                $data->plan_subscription_id = $request->plan_subscription_id;
                $data->transaction_id = $transaction_id;
                $data->transaction_amount = $request->transaction_amount;
                $data->coin = $request->coin;
                $data->transaction_date = date("Y-m-d");

                if ($data->save()) {
                    $plus = Users::where('id', $data->user_id)->first();
                    if ($plus) {
                        $sum = $plus->total_points + $data->coin;
                        $plus->total_points = $sum;
                        $plus->save();
                    }
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.record_add_successfully');
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function get_package_transaction(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $msg['status'] = 200;
                $msg['message'] = __('api_msg.get_record_successfully');

                $data = Transaction::where('user_id', $request->user_id)->get();
                if (count($data)) {
                    for ($i = 0; $i < count($data); $i++) {
                        $package_name = Subscription_Plan::where('id', $data[$i]->plan_subscription_id)->first();
                        if ($package_name) {
                            $data[$i]->package_name = $package_name->name;
                        } else {
                            $data[$i]->package_name = "";
                        }
                    }
                    $msg['result'] = $data;
                } else {
                    $msg['result'] = [];
                }
                return $msg;
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}