<?php

namespace App\Http\Controllers\Api;

use Validator;
use App\Models\Users;
use App\Models\Level;
use App\Models\Category;
use App\Models\Question;
use Illuminate\Http\Request;
use App\Models\Classification;
use App\Models\Contest_Report;
use App\Models\Earn_transaction;
use App\Models\Earnpoint_Setting;
use App\Models\QuestioLeaderboard;
use App\Models\Pratice_Leaderborad;
use App\Http\Controllers\Controller;

class QuestionController extends Controller
{

    public function question_by_level_id(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'category_id' => 'required',
                'level_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Question::inRandomOrder()
                    ->where('level_id', $request->level_id)
                    ->where('category_id', $request->category_id)
                    ->limit('10')
                    ->get();
                if ($data) {
                    for ($i = 0; $i < count($data); $i++) {
                        if ($data[$i]->image) {
                            $path = url('images/question/' . $data[$i]->image);
                            $data[$i]->image = $path;
                        } else {
                            $data[$i]->image = "";
                        }
                    }
                    $question['status'] = 200;
                    $question['message'] = __('api_msg.get_record_successfully');
                    $question['result'] = $data;
                    return $question;
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = "";
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function question_by_contest_id(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'contest_id' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $data = Question::inRandomOrder()->where('contest_id', $request->contest_id)->limit('10')->get();
                if ($data) {
                    for ($i = 0; $i < count($data); $i++) {
                        if ($data[$i]->image) {
                            $path = url('images/question/' . $data[$i]->image);
                            $data[$i]->image = $path;
                        } else {
                            $data[$i]->image = "";
                        }
                    }
                    $question['status'] = 200;
                    $question['message'] = __('api_msg.get_record_successfully');
                    $question['result'] = $data;
                    return $question;
                } else {
                    $msg['status'] = 200;
                    $msg['message'] = __('api_msg.get_record_successfully');
                    $msg['result'] = "";
                    return $msg;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function save_question_report(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'level_id' => 'required',
                'user_id' => 'required',
                'category_id' => 'required',
                'total_question' => 'required',
                'questions_attended' => 'required',
                'correct_answers' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $level_id = $request->level_id;
                $questions_attended = $request->questions_attended;
                $total_questions = $request->total_question;
                $correct_answers = $request->correct_answers;
                $user_id = $request->user_id;
                $category_id = $request->category_id;

                $level_info = Level::where('id', $level_id)->first();
                if ($level_info) {
                    $one_que_score = $level_info->score / $total_questions;
                    $tot_score = $one_que_score * $correct_answers;
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.level_not_found');
                    return $data;
                }

                $leaderboard = new QuestioLeaderboard();
                $leaderboard->user_id = $user_id;
                $leaderboard->level_id = $level_id;
                $leaderboard->question_level_master_id = 0;
                $leaderboard->category_id = $category_id;
                $leaderboard->total_questions = $total_questions;
                $leaderboard->questions_attended = $questions_attended;
                $leaderboard->correct_answers = $correct_answers;
                $leaderboard->score = $tot_score;
                $leaderboard->date = date("Y-m-d");

                if ($request->correct_answers >= $level_info->win_question_count) {
                    $leaderboard->is_unlock = 1;
                } else {
                    $leaderboard->is_unlock = 0;
                }

                if ($leaderboard->save()) {

                    $U_score = Users::where('id', $user_id)->first();
                    $PassLevelPoint = Earnpoint_Setting::where('type', 1)->first();

                    if ($U_score && $leaderboard->is_unlock == 1 && $PassLevelPoint) {

                        // Plus Point & Score in User
                        $score_sum = $U_score->total_score + $tot_score;
                        $point_sum = $U_score->total_points + $PassLevelPoint->value;

                        $U_score->total_score = $score_sum;
                        $U_score->total_points = $point_sum;
                        $U_score->save();

                        // Earn Transaction Table
                        $earn_transaction = new Earn_transaction();
                        $earn_transaction->user_id = $user_id;
                        $earn_transaction->contest_id = 0;
                        $earn_transaction->type = 2;
                        $earn_transaction->point = $PassLevelPoint->value;
                        $earn_transaction->save();
                    }
                    $data['status'] = 200;
                    $data['message'] = __('api_msg.record_add_successfully');
                    return $data;
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.data_not_save');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function save_Practice_Question_Report(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'level_id' => 'required',
                'question_level_master_id' => 'required',
                'category_id' => 'required',
                'total_question' => 'required',
                'question_attended' => 'required',
                'correct_answers' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $level_id = $request->level_id;
                $questions_attended = $request->question_attended;
                $total_questions = $request->total_question;
                $correct_answers = $request->correct_answers;
                $user_id = $request->user_id;
                $category_id = $request->category_id;
                $question_level_master_id = $request->question_level_master_id;

                $level_info = Level::where('id', $level_id)->first();
                if ($level_info) {
                    $one_que_score = $level_info->score / $total_questions;
                    $tot_score = $one_que_score * $correct_answers;
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.level_not_found');
                    return $data;
                }

                $leaderboard = new Pratice_Leaderborad();
                $leaderboard->user_id = $user_id;
                $leaderboard->level_id = $level_id;
                $leaderboard->question_level_master_id = $question_level_master_id;
                $leaderboard->category_id = $category_id;
                $leaderboard->total_questions = $total_questions;
                $leaderboard->questions_attended = $questions_attended;
                $leaderboard->correct_answers = $correct_answers;
                $leaderboard->score = $tot_score;
                $leaderboard->date = date("Y-m-d");

                if ($correct_answers >= $level_info->win_question_count) {
                    $leaderboard->is_unlock = 1;
                } else {
                    $leaderboard->is_unlock = 0;
                }

                if ($leaderboard->save()) {
                    $u_score = Users::where('id', $request->user_id)->first();
                    if ($u_score && $leaderboard->is_unlock == 1) {

                        // Plus Pratice Score in User
                        $sum = $u_score->pratice_quiz_score + $tot_score;
                        $total_score = $u_score->total_score + $tot_score;


                        $u_score->pratice_quiz_score = $sum;
                        $u_score->total_score = $total_score;

                        $u_score->save();
                    }
                    $data['status'] = 200;
                    $data['message'] = __('api_msg.record_add_successfully');
                    return $data;
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.data_not_save');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function save_contest_question_report(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id' => 'required',
                'contest_id' => 'required',
                'total_questions' => 'required',
                'questions_attended' => 'required',
                'correct_answers' => 'required',
                'question_json' => 'required',
            ]);
            if ($validator->fails()) {
                $data['status'] = 400;
                $data['message'] = __('api_msg.please_enter_required_fields');
                return $data;
            } else {
                $user_id = $request->user_id;
                $contest_id = $request->contest_id;
                $total_questions = $request->total_questions;
                $questions_attended = $request->questions_attended;
                $correct_answers = $request->correct_answers;
                $question_json = $request->question_json;

                $report = new Contest_Report();
                $report->user_id = $user_id;
                $report->contest_id = $contest_id;
                $report->total_questions = $total_questions;
                $report->questions_attended = $questions_attended;
                $report->correct_answers = $correct_answers;
                $report->question_json = $question_json;
                $report->score = $correct_answers;
                $report->is_unlock = 1;
                $report->status = 1;
                $report->date = date("Y-m-d");

                if ($report->save()) {
                    $data['status'] = 200;
                    $data['message'] = __('api_msg.thank_you_very_much_for_participate');
                    return $data;
                } else {
                    $data['status'] = 400;
                    $data['message'] = __('api_msg.data_not_save');
                    return $data;
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function make_winner($contestId)
    {
        try {
            $where = 'id=' . $contestId;

            // $contestData = $this->getByID($where, 'contest_master');
            $contestData = Contest::where('id', $contestId)->first();

            if (isset($contestData['id']) && $contestData['id'] != '') {
                $no_of_user_prize = $contestData['no_of_user_prize'];
                $whereGet = 'contest_id=' . $contestId;

                $rank = Contest_Report::select(DB::raw(' RANK() OVER (ORDER BY total_score DESC) as rank'), 'id', 'score', 'contest_id', 'user_id', DB::raw('SUM(score) As total_score'))
                    ->groupBy('user_id')
                    ->where('contest_id', $contestId)
                    ->orderBy('rank', 'ASC')
                    ->get();

                $winJson = json_decode($contestData['prize_json']);
                $data = [];
                foreach ($winJson->win_list as $row) {
                    $between = explode(' to ', $row->rank);
                    if (count($between) > 1) {
                        $rowData = $row;
                        for ($i = $between[0]; $i <= $between[1]; $i++) {
                            $rowData = [];
                            $rowData['rank'] = $i;
                            $rowData['winning_amount'] = $row->winning_amount;
                            $rowData['percentage'] = $row->percentage;
                            $data[] = $rowData;
                        }
                    } else {
                        $rowData = [];
                        $rowData['rank'] = $between[0];
                        $rowData['winning_amount'] = $row->winning_amount;
                        $rowData['percentage'] = $row->percentage;
                        $data[] = $rowData;
                    }
                }
                $winnList = array();
                foreach ($rank as $key => $usersData) {
                    $data[$key]['score'] = $usersData['score'];
                    $data[$key]['user_id'] = $usersData['user_id'];
                    $data[$key]['contest_id'] = $usersData['contest_id'];
                    $winnList[] = $data[$key];
                }
                $whereDelete = 'contest_id=' . $contestId;

                // $this->Common_model->delete($whereDelete, 'winners');
                $data = Winners::where('contest_id', $contestId)->delete();

                foreach ($winnList as $win) {
                    $winInsert['price'] = $win['winning_amount'];
                    $winInsert['percentage'] = $win['percentage'];
                    $winInsert['rank'] = $win['rank'];
                    $winInsert['score'] = $win['score'];
                    $winInsert['user_id'] = $win['user_id'];
                    $winInsert['contest_id'] = $win['contest_id'];

                    // $contestId = $this->Common_model->insert($winInsert, 'winners');
                    Winners::insert($winInsert);
                }
                return redirect(URL::to('/') . '/admin/contest');
            }
        } catch (Exception $e) {
            $res = array('status' => 400, 'message' => $this->lang->line('error'));
            echo json_encode($res);
            exit;
        }
    }
}