<?php 

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

function lang()
{
    $lang = \App\Models\Language::get();
    return $lang;
}

function setting_app_logo()
{
    $setting = \App\Models\General_Setting::get();
    $data = [];
    foreach ($setting as  $value) {
        $data[$value->key] = $value->value;
    }
    return $data['app_logo'];
}

function saveImage($org_name,$folder)
{   
	$img_ext = $org_name->getClientOriginalExtension();
	$filename = time() . '.' . $img_ext;
	$path = $org_name->move(public_path('images'.$folder), $filename);
	return $filename;
}

function Question_Is_unlock($user_id, $category_id, $level_id)
{
    $is_unlock = \App\Models\QuestioLeaderboard::where('user_id',$user_id)->where('category_id',$category_id)->where('level_id',$level_id)
            ->join('level','level.id','level_id')
            ->orderby('correct_answers','asc')
            ->first();
    return $is_unlock;
}

function API_contestList($contest_id)
{
    $contestList = \App\Models\Winners::select('rank','winners.id','contest_id','score','winners.user_id','users.username','users.profile_img','users.total_score as user_total_score')
                ->join('users','users.id','winners.user_id')
                ->where('contest_id', $contest_id)
                ->orderBy('rank','asc')
                ->get(); 
    return $contestList;
}

function API_contestListUser($user_id, $contest_id)
{
    $contestListUser = \App\Models\Winners::select('rank','winners.id','contest_id','score','winners.user_id','users.username','users.profile_img','users.total_score as user_total_score')
                ->join('users','users.id','winners.user_id')
                ->where('contest_id', $contest_id)
                ->where('user_id', $user_id)
                ->orderBy('rank','asc')
                ->first(); 
    return $contestListUser;
}

function string_cut($string, $len)
{
    if (strlen($string) > $len) {
        $string = mb_substr(strip_tags($string),0,$len,'utf-8') . '...';
        // $string = substr(strip_tags($string),0,$len).'...';
    }
    return $string;
}