
<?php $__env->startSection('title', __('Edit Flash Card')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>
      <h5>Study Set: <?php echo e($name); ?></h5>
      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('sets',['id'=>$setId])); ?>">Flash Cards</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
            Edit Flash Card
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="<?php echo e(route('sets',['id'=>$setId])); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('Flash Cards')); ?></a>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
      	<form enctype="multipart/form-data" id="save_edit_category">
      		<?php echo csrf_field(); ?>
      		<div class="form-row">
      			<div class="col-md-12 mb-3">
      				<div class="form-group">
      					<label for="name">Term</label>
      					<input name="question" type="text" class="form-control" id="name" value="<?php echo e($result->question); ?>">
      				</div>
      			</div>
      		</div>
          <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="description">Definition</label>
                        <textarea name="description"  id="description" row="4" class="form-control" 
                            ><?php echo e($result->description); ?> </textarea>
                    </div>
                </div>
            </div>
            <div class="form-row">
	    				<div class="col-md-6 mb-3">
	    					<div class="form-group">
	    						<label for="image">Term Image</label>
	    						<input type="file" class="form-control" id="image1" name="image1" value="<?php echo e($result->image1); ?>">
	    						<label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
	    					</div>
	    				</div>
	    				<div class="col-md-6 mb-3">
	    					<div class="form-group">
	    						<div class="custom-file ml-5">
	    							<?php 
										if($result->image1){
											$app = URL::asset('/images/sets').'/'.$result->image1;
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
    								<img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
	    							<input type="hidden" name="old_image1" value="<?php echo e($result->image1); ?>">
	    						</div>
	    					</div> 
	    				</div>
	    			</div>
            <div class="form-row">
	    				<div class="col-md-6 mb-3">
	    					<div class="form-group">
	    						<label for="image">Defnition Image</label>
	    						<input type="file" class="form-control" id="image" name="image" value="<?php echo e($result->image); ?>">
	    						<label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
	    					</div>
	    				</div>
	    				<div class="col-md-6 mb-3">
	    					<div class="form-group">
	    						<div class="custom-file ml-5">
	    							<?php 
										if($result->image){
											$app = URL::asset('/images/sets').'/'.$result->image;
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
    								<img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
	    							<input type="hidden" name="old_image" value="<?php echo e($result->image); ?>">
	    						</div>
	    					</div> 
	    				</div>
	    			</div>
      		<div class="border-top mt-2 pt-3">
      			<input type="hidden" value="<?php echo e($result->id); ?>" name="id">
      			<button type="button" class="btn btn-default mw-120" onclick="save_edit_category()"><?php echo e(__('Label.UPDATE')); ?></button>
            <a href="<?php echo e(route('sets',['id'=>$setId])); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
      		</div>
      	</form>
        
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
 <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script type="text/javascript">
    function save_edit_category(){
      $("#dvloader").show();
      var formData = new FormData($("#save_edit_category")[0]);
      $.ajax({
        type:'POST',
        url:'<?php echo e(route("setsUpdate")); ?>',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_edit_category', '<?php echo e(route("sets",["id"=>$setId])); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
          toastr.error(errorThrown.msg,'failed');         
        }
      });
    }
  </script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/sets/edit.blade.php ENDPATH**/ ?>