
<?php $__env->startSection('title', __('Label.Notification')); ?>
<?php $__env->startSection('content'); ?>
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"> <?php echo $__env->yieldContent('title'); ?> </h1>

      <div class="border-bottom row">
        <div class="col-sm-12">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              <?php echo e(__('Label.Notification List')); ?>

            </li>
          </ol>
        </div>
        <div class="col-sm-12 mb-3 d-flex justify-content-between">
          <a href="<?php echo e(route('notificationAdd')); ?>" class="btn btn-default mw-120"><?php echo e(__('Label.Add')); ?></a>
          <a href="<?php echo e(route('notificationSetting')); ?>" class="btn btn-default mw-120"><?php echo e(__('Label.Notification Setting')); ?></a>
        </div>
      </div>

      <div class="table-responsive mt-3">
        <table class="table table-striped notification-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> <?php echo e(__('Label.Id')); ?> </th>
              <th width="95px"> <?php echo e(__('Label.Image')); ?> </th>
              <th width="290px"> <?php echo e(__('Label.Title')); ?> </th>
              <th> <?php echo e(__('Label.Message')); ?> </th>
              <th width="125px"> <?php echo e(__('Label.Date')); ?> </th>
              <th width=""> <?php echo e(__('Label.Action')); ?> </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.notification-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' >",
              next: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [ [0, 'desc'] ],
          ajax: "<?php echo e(route('notificationData')); ?>",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'big_picture', name: 'big_picture',
            "render": function(data, type, full,meta) {
              if(data) {
                return "<img src='<?php echo e(url('images/notification/')); ?>/"+ data + "'  height=50 width=50 />";
              } else {
                return "<img src='<?php echo e(url('assets/imgs/1.png')); ?>'  height=50 width=50 />";
              } 
            }
          },
          {data: 'headings', name: 'headings'},
          {data: 'contents', name:'contents'},
          {data: 'c_date', name: 'date'}, 
          {data: 'action', name: 'action'}, 
          ],
        });
      });
    });
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/notification/index.blade.php ENDPATH**/ ?>