
<?php $__env->startSection('title', __('Label.Question Leaderboard')); ?>
<?php $__env->startSection('content'); ?>

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-12">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              <?php echo e(__('Label.Quiz Leaderboard')); ?>

            </li>
          </ol>
        </div>
      </div>

      <div class="border-bottom mb-3 pb-3">
        <form class="" action="<?php echo e(route('questionleaderboard')); ?>" method="GET">
          <div class="form-row">
            <div class="col-md-1 d-flex align-items-center">
              <label for="type"><?php echo e(__('Label.SEARCH')); ?> :</label>
            </div>
            <div class="col-md-2">
              <div class="form-group">
                <select class="form-control" id="type" name="type">
                <option value="" disabled><?php echo e(__('Label.Select Type')); ?></option>
                  <option value="today" <?php if(isset($_GET['type'])): ?><?php echo e($_GET['type'] == "today" ? 'selected' : ''); ?>  <?php endif; ?> > <?php echo e(__('Label.Today')); ?> </option>
                  <option value="month" <?php if(isset($_GET['type'])): ?><?php echo e($_GET['type'] == "month" ? 'selected' : ''); ?>  <?php endif; ?>> <?php echo e(__('Label.Month')); ?> </option>
                  <option value="all" <?php if(isset($_GET['type'])): ?><?php echo e($_GET['type'] == "all" ? 'selected' : ''); ?> <?php else: ?> selected <?php endif; ?>> <?php echo e(__('Label.All')); ?> </option>
                </select>
              </div>
            </div>
            <div class="col-sm-2 ml-4">
              <button class="btn btn-default" type="submit"> <?php echo e(__('Label.SEARCH')); ?> </button>
            </div>
          </div>
        </form>
      </div>
      
      <div class="table-responsive">
        <table class="table table-striped praticeleaderboard-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> <?php echo e(__('Label.Image')); ?> </th>
              <th> <?php echo e(__('Label.Name')); ?> </th>
              <th> <?php echo e(__('Label.Score')); ?> </th>
              <th> <?php echo e(__('Label.Rank')); ?> </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">

        $(document).ready(function() {
            $(function () {

              <?php if(isset($_GET['type']) != null): ?>
                var type = '<?php echo e($_GET['type']); ?>'; 
              <?php else: ?>
                var type = "all";
              <?php endif; ?>

              var url = "<?php echo e(route('questionleaderboardData', '')); ?>"+"/"+type;

              var table = $('.praticeleaderboard-table').DataTable({
                  "responsive": true,
                  "autoWidth": false,
                  lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
                  processing: true,
                  serverSide: false,
                  language: {
                    paginate: {
                      previous: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' >",
                      next: "<img src='<?php echo e(url('assets/imgs/left-arrow.png')); ?>' style='transform: rotate(180deg)'>"
                    }
                  },
                  order: [ [0, 'desc'] ],
                  ajax: url,
                  columns: [
                    {data: 'users.profile_img', name:'users.profile_img',
                      "render": function (data, type, full, meta) {
                      if(data){
                        return "<img src='<?php echo e(url('images/user/')); ?>/"+ data + "' height=50 width=70 />";
                      } else {
                        return "<img src='<?php echo e(url('assets/imgs/1.png')); ?>' height=50 width=70 />";
                      }
                    },
                    },
                    {data: 'users.username', name: 'users.username',
                      "render": function (data, type, full, meta) {
                        if(data){
                          return data;
                        } else {
                          return "-";
                        }
                      }
                    },
                    {data: 'total_score', name: 'total_score'},
                    {data: 'rank', name: 'rank'},
                  ],
              });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\envato\app\dtquiz_backend\resources\views/admin/question_leaderboard/index.blade.php ENDPATH**/ ?>