
<?php $__env->startSection('title', 'Settings'); ?>
<?php $__env->startSection('content'); ?>

<!-- Start: Body-Content -->
<div class="body-content">
    <!-- mobile title -->
    <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>

    <div class="border-bottom row mb-3">
        <div class="col-sm-12">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                    <?php echo e(__('Label.Setting')); ?>

                </li>
            </ol>
        </div>
    </div>

    <ul class="nav nav-pills custom-tabs inline-tabs" id="pills-tab" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="app-tab" data-toggle="pill" href="#app" role="tab" aria-controls="app"
                aria-selected="true">APP SETTINGS</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="change-password-tab" data-toggle="pill" href="#change-password" role="tab"
                aria-controls="change-password" aria-selected="true"><?php echo e(__('Label.CHANGE PASSWORD')); ?></a>
        </li>
        <!-- <li class="nav-item">
            <a class="nav-link" id="paymet-tab" data-toggle="pill" href="#payment" role="tab" aria-controls="payment"
                aria-selected="true"><?php echo e(__('Label.PAYMENT')); ?></a>
        </li> -->
        <li class="nav-item">
            <a class="nav-link" id="admob-tab" data-toggle="pill" href="#admob" role="tab" aria-controls="admob"
                aria-selected="false"><?php echo e(__('Label.ADMOB')); ?></a>
        </li>
        <!-- <li class="nav-item">
            <a class="nav-link" id="facebook-ads-tab" data-toggle="pill" href="#facebook-ads" role="tab"
                aria-controls="facebook-ads" aria-selected="false"><?php echo e(__('Label.FACEBOOK ADS')); ?></a>
        </li> -->
        <!-- <li class="nav-item">
          <a class="nav-link" id="purchase-code-tab" data-toggle="pill" href="#purchase-code" role="tab"
          aria-controls="purchase-code" aria-selected="false"><?php echo e(__('Label.PURCHASE CODE')); ?></a>
        </li> -->
    </ul>

    <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="app" role="tabpanel" aria-labelledby="app-tab">
            <div class="app-right-btn">
                <a href="<?php echo e(route('settingsmtpindex')); ?>" class="btn btn-default">EMAIL SETTINGS [SMTP]</a>
            </div>
            <div class="card custom-border-card">
                <h5 class="card-header">App Configrations</h5>
                <div class="card-body">
                    <div class="input-group">
                        <div class="col-2">
                            <label class="ml-5 pt-3" style="font-size:16px; font-weight:500; color:#1b1b1b">API
                                Path</label>
                        </div>
                        <input type="text" readonly value="<?php echo e(url('/')); ?>/api" name="api_path" class="form-control"
                            style="background-color:matte gray;" id="api_path">
                        <div class="input-group-prepend">
                            <div class="input-group-text btn" style="background-color:matte gray;"
                                onclick="Function_Api_path()">
                                <img src="<?php echo e(url('/')); ?>/assets/imgs/copy.png" alt="" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card custom-border-card">
                <h5 class="card-header">App Settings</h5>
                <div class="card-body">
                    <form id="app_setting" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row col-lg-12">
                            <div class="form-group col-lg-6">
                                <label for="app_name"><?php echo e(__('Label.App Name')); ?></label>
                                <input type="text" name="app_name" class="form-control" id="app_name"
                                    placeholder="Enter App Name" value="<?php echo e($result['app_name']); ?>">
                            </div>
                            <div class="form-group col-lg-6">
                                <label><?php echo e(__('Label.Host Email')); ?></label>
                                <input type="text" name="host_email" class="form-control" id="host_email"
                                    value="<?php echo e($result['host_email']); ?>" placeholder="Enter Host Email">
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group col-lg-6">
                                <label><?php echo e(__('Label.App Version')); ?></label>
                                <input type="text" name="app_version" class="form-control" id="app_version"
                                    value="<?php echo e($result['app_version']); ?>" placeholder="Enter App Version">
                            </div>
                            <div class="form-group col-lg-6">
                                <label><?php echo e(__('Label.Author')); ?></label>
                                <input type="text" name="Author" class="form-control" id="Author"
                                    value="<?php echo e($result['Author']); ?>" placeholder="Enter Author">
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group col-lg-6">
                                <label><?php echo e(__('Label.Email')); ?> </label>
                                <input type="text" name="email" class="form-control" id="email"
                                    value="<?php echo e($result['email']); ?>" placeholder="Enter Email">
                            </div>
                            <div class="form-group  col-lg-6">
                                <label> <?php echo e(__('Label.Contact')); ?> </label>
                                <input type="text" name="contact" class="form-control" id="contact"
                                    value="<?php echo e($result['contact']); ?>" placeholder="Enter Contact">
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group col-lg-12">
                                <label><?php echo e(__('Label.APP DESCRIPATION')); ?></label>
                                <textarea name="app_desripation" class="form-control summernote" id="app_desripation"
                                    placeholder="Enter App Descripation"><?php echo e($result['app_desripation']); ?></textarea>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group col-lg-12">
                                <label><?php echo e(__('Label.PRIVACY POLICY')); ?></label>
                                <textarea name="privacy_policy" class="form-control summernote" id="privacy_policy"
                                    placeholder="Enter Privacy Policy"><?php echo e($result['privacy_policy']); ?></textarea>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group col-lg-12">
                                <label><?php echo e(__('Label.Instrucation')); ?></label>
                                <textarea name="instrucation" class="form-control summernote" id="instrucation"
                                    placeholder="Instrucation"><?php echo e($result['instrucation']); ?></textarea>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group col-lg-6">
                                <label for="app_logo"><?php echo e(__('Label.APP IMAGE')); ?></label>
                                <input type="file" name="app_logo" class="form-control" id="app_logo"
                                    placeholder="Enter Your App Name" value="<?php echo e($result['app_logo']); ?>">
                                <label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
                            </div>
                            <div class="form-group col-lg-6">
                                <label><?php echo e(__('Label.WEBSITE')); ?></label>
                                <input type="text" name="website" class="form-control" id="website"
                                    value="<?php echo e($result['website']); ?>" placeholder="Enter Website">
                            </div>
                        </div>
                        <div class="col-md-6 mb-5">
                            <div class="form-group">
                                <div class="custom-file ml-5">
                                    <?php
                                    if ($result['app_logo']) {
                                        $app = URL::asset('/images/app') . '/' . $result['app_logo'];
                                    } else {
                                        $app = URL::asset('/assets/imgs/1.png');
                                    }
                                    ?>
                                    <img src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-5"
                                        id="preview-image-before-upload">
                                    <input type="hidden" name="old_app_logo" value="<?php echo e($result['app_logo']); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120"
                                onclick="app_setting()"><?php echo e(__('Label.SAVE')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card custom-border-card">
                <h5 class="card-header">Currency Settings</h5>
                <div class="card-body">
                    <form id="save_currency">
                        <?php echo e(csrf_field()); ?>

                        <div class="row col-lg-12">
                            <div class="form-group col-lg-6">
                                <label><?php echo e(__('Label.Currency Name')); ?> </label>
                                <input type="text" name="currency" class="form-control" value="<?php echo e($result['currency']); ?>"
                                    placeholder="Enter Currency Name">
                            </div>
                            <div class="form-group col-lg-6">
                                <label> <?php echo e(__('Label.Currency Code')); ?> </label>
                                <input type="text" name="currency_code" class="form-control"
                                    value="<?php echo e($result['currency_code']); ?>" placeholder="Enter Currency Code">
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120"
                                onclick="save_currency()"><?php echo e(__('Label.SAVE')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="change-password" role="tabpanel" aria-labelledby="change-password-tab">
            <div class="card custom-border-card">
                <h5 class="card-header"><?php echo e(__('Label.Change Password')); ?></h5>
                <div class="card-body">
                    <div class="">
                        <div class="form-group">
                            <form id="change_password">
                                <?php echo e(csrf_field()); ?>

                                <input type="hidden" name="admin_id" value="1">
                                <div class="row">
                                    <div class="form-group col-lg-12">
                                        <label for="password"><?php echo e(__('Label.New Password')); ?></label>
                                        <input type="password" name="password" class="form-control" id="password"
                                            placeholder="Enter New Password">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-lg-12">
                                        <label for="confirm_password"><?php echo e(__('Label.Confirm Password')); ?></label>
                                        <input type="password" name="confirm_password" class="form-control"
                                            id="confirm_password" placeholder="Enter Confirm Password">
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120"
                                        onclick="change_password()"><?php echo e(__('Label.SAVE')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="payment" role="tabpanel" aria-labelledby="paymet-tab">
            <div class="card custom-border-card">
                <h5 class="card-header"><?php echo e(__('Label.Payment')); ?></h5>
                <div class="card-body">
                    <form id="Payment">
                        <?php echo e(csrf_field()); ?>

                        <div class="row col-lg-12">
                            <div class="form-group  col-lg-6">
                                <label for="payment_1"><?php echo e(__('Label.Payment Name')); ?></label>
                                <input type="text" name="payment_1" class="form-control" id="payment_1"
                                    placeholder="Payment 1" value="<?php echo e($result['payment_1']); ?>">
                            </div>
                            <div class="form-group  col-lg-1"></div>
                            <div class="form-group  col-lg-5 ">
                                <label for="status1">Status</label>
                                <div class="form-group row">
                                    <div class="col-sm-6">
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status1" name="payment_status_1"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_1']==1)? "checked" : ""); ?> value="1">
                                                <label class="custom-control-label"
                                                    for="status1"><?php echo e(__('Label.Yes')); ?></label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status_1" name="payment_status_1"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_1']==0)? "checked" : ""); ?> value="0">
                                                <label class="custom-control-label"
                                                    for="status_1"><?php echo e(__('Label.No')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group  col-lg-6">
                                <label for="payment_2"><?php echo e(__('Label.Payment Name')); ?></label>
                                <input type="text" name="payment_2" class="form-control" id="payment_2"
                                    placeholder="Payment 2" value="<?php echo e($result['payment_2']); ?>">
                            </div>
                            <div class="form-group  col-lg-1"></div>
                            <div class="form-group  col-lg-5">
                                <label for="status2">Status</label>
                                <div class="form-group row ">
                                    <div class="col-sm-6">
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status2" name="payment_status_2"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_2']==1)? "checked" : ""); ?> value="1">
                                                <label class="custom-control-label"
                                                    for="status2"><?php echo e(__('Label.Yes')); ?></label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status_2" name="payment_status_2"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_2']==0)? "checked" : ""); ?> value="0">
                                                <label class="custom-control-label"
                                                    for="status_2"><?php echo e(__('Label.No')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group  col-lg-6">
                                <label for="payment_3"><?php echo e(__('Label.Payment Name')); ?></label>
                                <input type="text" name="payment_3" class="form-control" id="payment_3"
                                    placeholder="Payment 3" value="<?php echo e($result['payment_3']); ?>">
                            </div>
                            <div class="form-group  col-lg-1"></div>
                            <div class="form-group  col-lg-5">
                                <label for="status3">Status</label>
                                <div class="form-group row">
                                    <div class="col-sm-6">
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status3" name="payment_status_3"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_3']==1)? "checked" : ""); ?> value="1">
                                                <label class="custom-control-label"
                                                    for="status3"><?php echo e(__('Label.Yes')); ?></label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status_3" name="payment_status_3"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_3']==0)? "checked" : ""); ?> value="0">
                                                <label class="custom-control-label"
                                                    for="status_3"><?php echo e(__('Label.No')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group  col-lg-6">
                                <label for="payment_4"><?php echo e(__('Label.Payment Name')); ?></label>
                                <input type="text" name="payment_4" class="form-control" id="payment_4"
                                    placeholder="Payment 4" value="<?php echo e($result['payment_4']); ?>">
                            </div>
                            <div class="form-group  col-lg-1"></div>
                            <div class="form-group  col-lg-5">
                                <label for="status4">Status</label>
                                <div class="form-group row">
                                    <div class="col-sm-6">
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status4" name="payment_status_4"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_4']==1)? "checked" : ""); ?> value="1">
                                                <label class="custom-control-label"
                                                    for="status4"><?php echo e(__('Label.Yes')); ?></label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status_4" name="payment_status_4"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_4']==0)? "checked" : ""); ?> value="0">
                                                <label class="custom-control-label"
                                                    for="status_4"><?php echo e(__('Label.No')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row col-lg-12">
                            <div class="form-group  col-lg-6">
                                <label for="payment_5"><?php echo e(__('Label.Payment Name')); ?></label>
                                <input type="text" name="payment_5" class="form-control" id="payment_5"
                                    placeholder="Payment 5" value="<?php echo e($result['payment_5']); ?>">
                            </div>
                            <div class="form-group  col-lg-1"></div>
                            <div class="form-group  col-lg-5">
                                <label for="status5">Status</label>
                                <div class="form-group row">
                                    <div class="col-sm-6">
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status5" name="payment_status_5"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_5']==1)? "checked" : ""); ?> value="1">
                                                <label class="custom-control-label"
                                                    for="status5"><?php echo e(__('Label.Yes')); ?></label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="status_5" name="payment_status_5"
                                                    class="custom-control-input"
                                                    <?php echo e(($result['payment_status_5']==0)? "checked" : ""); ?> value="0">
                                                <label class="custom-control-label"
                                                    for="status_5"><?php echo e(__('Label.No')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120"
                                onclick="Payment()"><?php echo e(__('Label.SAVE')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="admob" role="tabpanel" aria-labelledby="admob-tab">
            <div class="card custom-border-card mt-3">
                <h5 class="card-header">Android Settings</h5>
                <div class="card-body">
                    <form id="admob_android">
                        <?php echo e(csrf_field()); ?>

                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="banner_ad"><?php echo e(__('Label.Banner Ad')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="banner_ad" name="banner_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['banner_ad']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="banner_ad"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="banner_ad1" name="banner_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['banner_ad']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="banner_ad1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="interstital_ad"><?php echo e(__('Label.Interstital Ad')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="interstital_ad" name="interstital_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['interstital_ad']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="interstital_ad"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="interstital_ad1" name="interstital_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['interstital_ad']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="interstital_ad1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="reward_ad">Reward Ad</label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="reward_ad" name="reward_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['reward_ad']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="reward_ad"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="reward_ad1" name="reward_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['reward_ad']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="reward_ad1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="banner_adid"><?php echo e(__('Label.Banner Ad ID')); ?></label>
                                    <input type="text" name="banner_adid" class="form-control" id="banner_adid"
                                        placeholder="Enter Banner Ad ID" value="<?php echo e($result['banner_adid']); ?>">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="interstital_adid"><?php echo e(__('Label.Interstital Ad ID')); ?></label>
                                    <input type="text" name="interstital_adid" class="form-control"
                                        id="interstital_adid" placeholder="Enter interstital Ad ID"
                                        value="<?php echo e($result['interstital_adid']); ?>">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="reward_adid">Reward Ad ID</label>
                                    <input type="text" name="reward_adid" class="form-control" id="reward_adid"
                                        placeholder="Enter Reward Ad ID" value="<?php echo e($result['reward_adid']); ?>">
                                </div>
                            </div>

                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label></label>
                                    &nbsp;
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="interstital_adclick">Interstital Ad Click</label>
                                    <input type="text" name="interstital_adclick" class="form-control"
                                        id="interstital_adclick" placeholder="Enter Interstital Ad Click"
                                        value="<?php echo e($result['interstital_adclick']); ?>">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="reward_adclick">Reward Ad Click</label>
                                    <input type="text" name="reward_adclick" class="form-control"
                                        placeholder="Enter Reward Ad Click" value="<?php echo e($result['reward_adclick']); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120"
                                onclick="admob_android()"><?php echo e(__('Label.SAVE')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card custom-border-card mt-3">
                <h5 class="card-header">IOS Settings</h5>
                <div class="card-body">
                    <form id="admob_ios">
                        <?php echo e(csrf_field()); ?>

                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="ios_banner_ad"><?php echo e(__('Label.Banner Ad')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="ios_banner_ad" name="ios_banner_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['ios_banner_ad']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="ios_banner_ad"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="ios_banner_ad1" name="ios_banner_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['ios_banner_ad']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="ios_banner_ad1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="ios_interstital_ad"><?php echo e(__('Label.Interstital Ad')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="ios_interstital_ad" name="ios_interstital_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['ios_interstital_ad']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="ios_interstital_ad"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="ios_interstital_ad1" name="ios_interstital_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['ios_interstital_ad']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="ios_interstital_ad1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="ios_reward_ad">Reward Ad</label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="ios_reward_ad" name="ios_reward_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['ios_reward_ad']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="ios_reward_ad"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="ios_reward_ad1" name="ios_reward_ad"
                                                class="custom-control-input"
                                                <?php echo e(($result['ios_reward_ad']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="ios_reward_ad1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="ios_banner_adid"><?php echo e(__('Label.Banner Ad ID')); ?></label>
                                    <input type="text" name="ios_banner_adid" class="form-control" id="ios_banner_adid"
                                        placeholder="Enter Banner Ad ID" value="<?php echo e($result['ios_banner_adid']); ?>">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="ios_interstital_adid"><?php echo e(__('Label.Interstital Ad ID')); ?></label>
                                    <input type="text" name="ios_interstital_adid" class="form-control"
                                        id="ios_interstital_adid" placeholder="Enter interstital Ad ID"
                                        value="<?php echo e($result['ios_interstital_adid']); ?>">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="ios_reward_adid">Reward Ad ID</label>
                                    <input type="text" name="ios_reward_adid" class="form-control" id="ios_reward_adid"
                                        placeholder="Enter Reward Ad ID" value="<?php echo e($result['ios_reward_adid']); ?>">
                                </div>
                            </div>

                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label></label>
                                    &nbsp;
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="ios_interstital_adclick">Interstital Ad Click</label>
                                    <input type="text" name="ios_interstital_adclick" class="form-control"
                                        id="ios_interstital_adclick" placeholder="Enter Interstital Ad Click"
                                        value="<?php echo e($result['ios_interstital_adclick']); ?>">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="ios_reward_adclick">Reward Ad Click</label>
                                    <input type="text" name="ios_reward_adclick" class="form-control"
                                        placeholder="Enter Reward Ad Click" value="<?php echo e($result['ios_reward_adclick']); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120"
                                onclick="admob_ios()"><?php echo e(__('Label.SAVE')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="facebook-ads" role="tabpanel" aria-labelledby="facebook-ads-tab">
            <div class="card custom-border-card mt-3">
                <h5 class="card-header">Android Settings</h5>
                <div class="card-body">
                    <form id="fbad">
                        <?php echo e(csrf_field()); ?>

                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_native_status"><?php echo e(__('Label.Native Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_native_status" name="fb_native_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_native_status']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="fb_native_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_native_status1" name="fb_native_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_native_status']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="fb_native_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_banner_status"><?php echo e(__('Label.Banner Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_banner_status" name="fb_banner_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_banner_status']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="fb_banner_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_banner_status1" name="fb_banner_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_banner_status']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="fb_banner_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_interstiatial_status"><?php echo e(__('Label.Interstiatial Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_interstiatial_status"
                                                name="fb_interstiatial_status" class="custom-control-input"
                                                <?php echo e(($result['fb_interstiatial_status']=='1')? "checked" : ""); ?>

                                                value="1">
                                            <label class="custom-control-label"
                                                for="fb_interstiatial_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_interstiatial_status1"
                                                name="fb_interstiatial_status" class="custom-control-input"
                                                <?php echo e(($result['fb_interstiatial_status']=='0')? "checked" : ""); ?>

                                                value="0">
                                            <label class="custom-control-label"
                                                for="fb_interstiatial_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_native_id">Native Key</label>
                                    <input type="text" name="fb_native_id" class="form-control" id="fb_native_id"
                                        value="<?php echo e($result['fb_native_id']); ?>" placeholder="Enter Native Key">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_banner_id">Banner Key</label>
                                    <input type="text" name="fb_banner_id" class="form-control" id="fb_banner_id"
                                        value="<?php echo e($result['fb_banner_id']); ?>" placeholder="Enter Banner key">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_interstiatial_id">Interstiatial Key</label>
                                    <input type="text" name="fb_interstiatial_id" class="form-control"
                                        id="fb_interstiatial_id" value="<?php echo e($result['fb_interstiatial_id']); ?>"
                                        placeholder="Enter Interstiatial Key">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group col-lg-6">
                                    <label for="fb_rewardvideo_status"><?php echo e(__('Label.RewardVideo Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_rewardvideo_status" name="fb_rewardvideo_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_rewardvideo_status']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="fb_rewardvideo_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_rewardvideo_status1" name="fb_rewardvideo_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_rewardvideo_status']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="fb_rewardvideo_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group col-lg-6">
                                    <label for="fb_native_full_status"><?php echo e(__('Label.Native Full Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_native_full_status" name="fb_native_full_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_native_full_status']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="fb_native_full_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_native_full_status1" name="fb_native_full_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_native_full_status']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="fb_native_full_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_rewardvideo_id">Rewardvideo Status Key</label>
                                    <input type="text" name="fb_rewardvideo_id" class="form-control"
                                        id="fb_rewardvideo_id" value="<?php echo e($result['fb_rewardvideo_id']); ?>"
                                        placeholder="Enter Reward Video Status Key">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_native_full_id">Native Full Key</label>
                                    <input type="text" name="fb_native_full_id" class="form-control"
                                        id="fb_native_full_id" value="<?php echo e($result['fb_native_full_id']); ?>"
                                        placeholder="Enter Native Full Key">
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120"
                                onclick="fbad()"><?php echo e(__('Label.SAVE')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card custom-border-card mt-3">
                <h5 class="card-header">IOS Settings</h5>
                <div class="card-body">
                    <form id="fbad_ios">
                        <?php echo e(csrf_field()); ?>

                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_ios_native_status"><?php echo e(__('Label.Native Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_native_status" name="fb_ios_native_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_ios_native_status']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="fb_ios_native_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_native_status1" name="fb_ios_native_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_ios_native_status']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="fb_ios_native_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_ios_banner_status"><?php echo e(__('Label.Banner Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_banner_status" name="fb_ios_banner_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_ios_banner_status']=='1')? "checked" : ""); ?> value="1">
                                            <label class="custom-control-label"
                                                for="fb_ios_banner_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_banner_status1" name="fb_ios_banner_status"
                                                class="custom-control-input"
                                                <?php echo e(($result['fb_ios_banner_status']=='0')? "checked" : ""); ?> value="0">
                                            <label class="custom-control-label"
                                                for="fb_ios_banner_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label
                                        for="fb_ios_interstiatial_status"><?php echo e(__('Label.Interstiatial Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_interstiatial_status"
                                                name="fb_ios_interstiatial_status" class="custom-control-input"
                                                <?php echo e(($result['fb_ios_interstiatial_status']=='1')? "checked" : ""); ?>

                                                value="1">
                                            <label class="custom-control-label"
                                                for="fb_ios_interstiatial_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_interstiatial_status1"
                                                name="fb_ios_interstiatial_status" class="custom-control-input"
                                                <?php echo e(($result['fb_ios_interstiatial_status']=='0')? "checked" : ""); ?>

                                                value="0">
                                            <label class="custom-control-label"
                                                for="fb_ios_interstiatial_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_ios_native_id">Native Key</label>
                                    <input type="text" name="fb_ios_native_id" class="form-control"
                                        id="fb_ios_native_id" value="<?php echo e($result['fb_ios_native_id']); ?>"
                                        placeholder="Enter Native Key">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_ios_banner_id">Banner Key</label>
                                    <input type="text" name="fb_ios_banner_id" class="form-control"
                                        id="fb_ios_banner_id" value="<?php echo e($result['fb_ios_banner_id']); ?>"
                                        placeholder="Enter Banner Key">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_ios_interstiatial_id">Interstiatial Key</label>
                                    <input type="text" name="fb_ios_interstiatial_id" class="form-control"
                                        id="fb_ios_interstiatial_id" value="<?php echo e($result['fb_ios_interstiatial_id']); ?>"
                                        placeholder="Enter Interstiatial Key">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group col-lg-6">
                                    <label for="fb_ios_rewardvideo_status"><?php echo e(__('Label.RewardVideo Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_rewardvideo_status"
                                                name="fb_ios_rewardvideo_status" class="custom-control-input"
                                                <?php echo e(($result['fb_ios_rewardvideo_status']=='1')? "checked" : ""); ?>

                                                value="1">
                                            <label class="custom-control-label"
                                                for="fb_ios_rewardvideo_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_rewardvideo_status1"
                                                name="fb_ios_rewardvideo_status" class="custom-control-input"
                                                <?php echo e(($result['fb_ios_rewardvideo_status']=='0')? "checked" : ""); ?>

                                                value="0">
                                            <label class="custom-control-label"
                                                for="fb_ios_rewardvideo_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group col-lg-6">
                                    <label for="fb_ios_native_full_status"><?php echo e(__('Label.Native Full Status')); ?></label>
                                    <div class="radio-group">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_native_full_status"
                                                name="fb_ios_native_full_status" class="custom-control-input"
                                                <?php echo e(($result['fb_ios_native_full_status']=='1')? "checked" : ""); ?>

                                                value="1">
                                            <label class="custom-control-label"
                                                for="fb_ios_native_full_status"><?php echo e(__('Label.Yes')); ?></label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="fb_ios_native_full_status1"
                                                name="fb_ios_native_full_status" class="custom-control-input"
                                                <?php echo e(($result['fb_ios_native_full_status']=='0')? "checked" : ""); ?>

                                                value="0">
                                            <label class="custom-control-label"
                                                for="fb_ios_native_full_status1"><?php echo e(__('Label.No')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_ios_rewardvideo_id">Rewardvideo Status Key</label>
                                    <input type="text" name="fb_ios_rewardvideo_id" class="form-control"
                                        id="fb_ios_rewardvideo_id" value="<?php echo e($result['fb_ios_rewardvideo_id']); ?>"
                                        placeholder="Enter Reward Video Status Key">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 col-md-4">
                                <div class="form-group">
                                    <label for="fb_ios_native_full_id">Native Full Key</label>
                                    <input type="text" name="fb_ios_native_full_id" class="form-control"
                                        id="fb_ios_native_full_id" value="<?php echo e($result['fb_ios_native_full_id']); ?>"
                                        placeholder="Enter native Full Key">
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120"
                                onclick="fbad_ios()"><?php echo e(__('Label.SAVE')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- <div class="tab-pane fade" id="purchase-code" role="tabpanel" aria-labelledby="purchase-code-tab">
          <div class="card custom-border-card mt-3">
            <h5 class="card-header"><?php echo e(__('Label.Purchase Code')); ?></h5>
            <div class="card-body">
              <form id="purchase">
                <?php echo e(csrf_field()); ?>

                <div class="row col-lg-12">
                  <div class="form-group col-lg-6">
                    <label><?php echo e(__('Label.Purchase Code')); ?> <a  href="#" >
                    <?php echo e(__('Label.[Where Is My Purchase Code?]')); ?> </a></label>
                    <input type="text" name="purchase_code" class="form-control" id="purchase_code" value="<?php echo e($result['purchase_code']); ?>">
                  </div>
                  <div class="form-group col-lg-6">
                    <label> <?php echo e(__('Label.Package Name')); ?> </label>
                    <input type="text" name="package_name" class="form-control" id="package_name" value="<?php echo e($result['package_name']); ?>">
                  </div>
                </div>                
                <div class="border-top pt-3">
                  <button type="button" class="btn btn-default mw-120" onclick="purchase()"><?php echo e(__('Label.SAVE')); ?></button>
                </div>
              </form>
            </div>
          </div>
        </div> -->
    </div>

</div>
<!-- End: Body-Content -->
</div>
<!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
function app_setting() {
    $("#dvloader").show();
    var formData = new FormData($("#app_setting")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingapp")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'app_setting', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

$(document).ready(function(e) {
    $('#app_logo').change(function() {
        let reader = new FileReader();
        reader.onload = (e) => {
            $('#preview-image-before-upload').attr('src', e.target.result);
        }
        reader.readAsDataURL(this.files[0]);
    });
});

function change_password() {
    $("#dvloader").show();
    var formData = new FormData($("#change_password")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingchangepassword")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'change_password', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

function Payment() {
    $("#dvloader").show();
    var formData = new FormData($("#Payment")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingpayment")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'Payment', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

function save_currency() {
    $("#dvloader").show();
    var formData = new FormData($("#save_currency")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingcurrency")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'save_currency', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

function admob_android() {
    $("#dvloader").show();
    var formData = new FormData($("#admob_android")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingadmob_android")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'admob_android', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

function admob_ios() {
    $("#dvloader").show();
    var formData = new FormData($("#admob_ios")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingadmob_ios")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'admob_ios', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

function fbad() {
    $("#dvloader").show();
    var formData = new FormData($("#fbad")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingfacebookad")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'fbad', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

function fbad_ios() {
    $("#dvloader").show();
    var formData = new FormData($("#fbad_ios")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingfacebookad_ios")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'fbad_ios', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

function purchase() {
    $("#dvloader").show();
    var formData = new FormData($("#purchase")[0]);
    $.ajax({
        type: 'POST',
        url: '<?php echo e(route("settingpurchasecode")); ?>',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(resp) {
            $("#dvloader").hide();
            get_responce_message(resp, 'purchase', '<?php echo e(route("setting")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
            $("#dvloader").hide();
            toastr.error(errorThrown.msg, 'failed');
        }
    });
}

function Function_Api_path() {
    /* Get the text field */
    var copyText = document.getElementById("api_path");

    /* Select the text field */
    copyText.select();
    copyText.setSelectionRange(0, 99999); /* For mobile devices */

    document.execCommand('copy');

    /* Alert the copied text */
    alert("Copied the API Path: " + copyText.value);
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\envato\app\dtquiz_backend\resources\views/admin/setting/index.blade.php ENDPATH**/ ?>