
<?php $__env->startSection('title',  __('Label.Add Classification')); ?>
<?php $__env->startSection('content'); ?>
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
            </li>
            <li class="breadcrumb-item">
              <a href="<?php echo e(route('classification')); ?>"><?php echo e(__('Label.Classification')); ?></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
               <?php echo e(__('Label.Add Classification')); ?>

            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="<?php echo e(route('classification')); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('Label.Classification')); ?></a>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
        <form id="save_classification">
          <?php echo csrf_field(); ?>

          <div class="form-row">
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label for="level_name"><?php echo e(__('Label.NAME')); ?></label>
                <input name="level_name" type="text" class="form-control" id="level_name" placeholder="<?php echo e(__('Label.Please Enter Name')); ?>">
              </div>
            </div>
          </div>
          <div class="form-row">
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label for="level_order"><?php echo e(__('Label.LEVEL ORDER NO')); ?></label>
                <input name="level_order" type="number" class="form-control" id="level_order" placeholder="<?php echo e(__('Label.Enter Level Order')); ?>">
              </div>
            </div>
          </div>
          <div class="border-top mt-2 pt-3">
           <button type="button" class="btn btn-default mw-120" onclick="save_classification()"><?php echo e(__('Label.SAVE')); ?></button>
           <a href="<?php echo e(route('classification')); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
         </div>
       </form>
     </div>
   </div>
   <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
	<script type="text/javascript">

    function save_classification(){
      $("#dvloader").show();
      var formData = new FormData($("#save_classification")[0]);
      $.ajax({
        type:'POST',
        url:'<?php echo e(route("classificationSave")); ?>',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_classification', '<?php echo e(route("classification")); ?>');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
          toastr.error(errorThrown.msg,'failed');         
        }
      });
    }
  </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/classification/add.blade.php ENDPATH**/ ?>