<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('auth.login');
// });

// Login-Logout
Route::get('/ajax-list','Auth\AdminController@getAjaxList')->name('ajax-list');
Route::get('/test', 'Auth\AdminController@pageTest')->name('test');
Route::get('/', 'Auth\AdminController@getLogin')->name('adminLogin');
Route::post('admin/login', 'Auth\AdminController@postLogin')->name('adminLoginPost');
Route::get('admin/logout', 'Auth\AdminController@logout')->name('adminLogout');

Route::get('/home', 'Admin\AdminController@dashboard')->name('home');

Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => 'authadmin'], function () {
    // Dashboard
    Route::get('dashboard', 'AdminController@dashboard')->name('dashboard');

        // Points
        Route::get('points', 'PointsController@index')->name('points');
        Route::get('points/data', 'PointsController@data')->name('pointsData');
        Route::get('points/add', 'PointsController@add')->name('pointsAdd');
        Route::post('points/save', 'PointsController@save')->name('pointsSave');
        Route::get('points/delete/{id}', 'PointsController@delete')->name('deletepoints');
        Route::get('points/edit/{id}', 'PointsController@edit')->name('editpoints');
        Route::post('points/update', 'PointsController@update')->name('pointsUpdate');


    // User
    Route::get('user', 'UserController@index')->name('user');
    Route::get('user/data', 'UserController@data')->name('userData');
    Route::get('user/add', 'UserController@add')->name('userAdd');
    Route::post('user/save', 'UserController@save')->name('userSave');
    Route::get('user/delete/{id}', 'UserController@delete')->name('deleteUser');
    Route::get('user/edit/{id}', 'UserController@edit')->name('editUser');
    Route::post('user/update', 'UserController@update')->name('userUpdate');
  // Pages
  Route::get('pages', 'PagesController@index')->name('pages');
  Route::get('pages/data', 'PagesController@data')->name('pagesData');
  Route::get('pages/add', 'PagesController@add')->name('pagesAdd');
  Route::post('pages/save', 'PagesController@save')->name('pagesSave');
  Route::get('pages/delete/{id}', 'PagesController@delete')->name('deletePages');
  Route::get('pages/edit/{id}', 'PagesController@edit')->name('editPages');
  Route::post('pages/update', 'PagesController@update')->name('pagesUpdate');

    // Study Sets
    Route::get('studyset', 'StudySetController@index')->name('studyset');
    Route::get('studyset/data', 'StudySetController@data')->name('studysetData');
    Route::get('studyset/add', 'StudySetController@add')->name('studysetAdd');
    Route::post('studyset/save', 'StudySetController@save')->name('studysetSave');
    Route::get('studyset/delete/{id}', 'StudySetController@delete')->name('deletestudyset');
    Route::get('studyset/edit/{id}', 'StudySetController@edit')->name('editstudyset');
    Route::post('studyset/update', 'StudySetController@update')->name('studysetUpdate');

        // FAQ
        Route::get('faq', 'FaqController@index')->name('faq');
        Route::get('faq/data', 'FaqController@data')->name('faqData');
        Route::get('faq/add', 'FaqController@add')->name('faqAdd');
        Route::post('faq/save', 'FaqController@save')->name('faqSave');
        Route::get('faq/delete/{id}', 'FaqController@delete')->name('deletefaq');
        Route::get('faq/edit/{id}', 'FaqController@edit')->name('editfaq');
        Route::post('faq/update', 'FaqController@update')->name('faqUpdate');

     //  Sets
     Route::get('sets/data/{id}', 'SetsController@index')->name('sets');
     Route::get('sets/data', 'SetsController@data')->name('setsData');
     Route::get('sets/add/{id}', 'SetsController@add')->name('setsAdd');
     Route::post('sets/save/{id}', 'SetsController@save')->name('setsSave');
     Route::get('sets/delete/{id}', 'SetsController@delete')->name('deletesets');
     Route::get('sets/edit/{id}/{setId}', 'SetsController@edit')->name('editsets');
     Route::post('sets/update', 'SetsController@update')->name('setsUpdate');

    // Category
    Route::get('category', 'CategoryController@index')->name('category');
    Route::get('category/data', 'CategoryController@data')->name('categoryData');
    Route::get('category/add', 'CategoryController@add')->name('categoryAdd');
    Route::post('category/save', 'CategoryController@save')->name('categorySave');
    Route::get('category/delete/{id}', 'CategoryController@delete')->name('deleteCategory');
    Route::get('category/edit/{id}', 'CategoryController@edit')->name('editCategory');
    Route::post('category/update', 'CategoryController@update')->name('categoryUpdate');

    // Level
    Route::get('level', 'LevelController@index')->name('level');
    Route::get('level/data', 'LevelController@data')->name('levelData');
    Route::get('level/add', 'LevelController@add')->name('levelAdd');
    Route::post('level/save', 'LevelController@save')->name('levelSave');
    Route::get('level/delete/{id}', 'LevelController@delete')->name('deleteLevel');
    Route::get('level/edit/{id}', 'LevelController@edit')->name('editLevel');
    Route::post('level/update', 'LevelController@update')->name('levelUpdate');

    // Classifition
    Route::get('classification', 'Classification_Controller@index')->name('classification');
    Route::get('classification/data', 'Classification_Controller@data')->name('classificationData');
    Route::get('classification/add', 'Classification_Controller@add')->name('classificationAdd');
    Route::post('classification/save', 'Classification_Controller@save')->name('classificationSave');
    Route::get('classification/delete/{id}', 'Classification_Controller@delete')->name('deleteClassification');
    Route::get('classification/edit/{id}', 'Classification_Controller@edit')->name('editClassification');
    Route::post('classification/update', 'Classification_Controller@update')->name('classificationUpdate');

    // Packages (plan Subscription)
    Route::get('subscription', 'Subscription_Plan_Controller@index')->name('subscription');
    Route::get('subscription/data', 'Subscription_Plan_Controller@data')->name('subscriptionData');
    Route::get('subscription/add', 'Subscription_Plan_Controller@add')->name('subscriptionAdd');
    Route::post('subscription/save', 'Subscription_Plan_Controller@save')->name('subscriptionSave');
    Route::get('subscription/delete/{id}', 'Subscription_Plan_Controller@delete')->name('deleteSubscription');
    Route::get('subscription/edit/{id}', 'Subscription_Plan_Controller@edit')->name('editSubscription');
    Route::post('subscription/update', 'Subscription_Plan_Controller@update')->name('subscriptionUpdate');

    // Contest List
    Route::get('contest', 'ContestController@index')->name('contest');
    Route::get('contest/data', 'ContestController@data')->name('contestData');
    Route::get('contest/add', 'ContestController@add')->name('contestAdd');
    Route::post('contest/save', 'ContestController@save')->name('contestSave');
    Route::get('contest/delete/{id}', 'ContestController@delete')->name('deleteContest');
    Route::get('contest/edit/{id}', 'ContestController@edit')->name('editContest');
    Route::post('contest/update', 'ContestController@update')->name('contestUpdate');
    Route::get('contest/make_winner/{id}', 'ContestController@make_winner')->name('contestMakeWinner');
    Route::get('contest/winner_list/{id}', 'ContestController@winner_list')->name('contestWinnerList');
    Route::get('contest/winner_list/data/{id}', 'ContestController@leaderboard')->name('contestWinnerListLeaderboard');

    // Contest question
    Route::get('contestquestion', 'ContestQuestionController@index')->name('contestquestion');
    Route::get('contestquestion/data', 'ContestQuestionController@data')->name('contestquestionData');
    Route::get('contestquestion/add', 'ContestQuestionController@add')->name('contestquestionAdd');
    Route::post('contestquestion/save', 'ContestQuestionController@save')->name('contestquestionSave');
    Route::get('contestquestion/delete/{id}', 'ContestQuestionController@delete')->name('deleteContestquestion');
    Route::get('contestquestion/edit/{id}', 'ContestQuestionController@edit')->name('editContestquestion');
    Route::post('contestquestion/update', 'ContestQuestionController@update')->name('contestquestionUpdate');

    // Contest Question Import
    Route::get('importcontestquestion', 'ContestQuestionImportController@index')->name('contestquestionimport');
    Route::get('contestquestionexport', 'ContestQuestionImportController@export')->name('contestquestion_export');
    Route::post('contestquestionimport', 'ContestQuestionImportController@import')->name('contestquestion_import');


    
    // Question question(Master)
    Route::get('question/data/{id}', 'QuestionController@index')->name('question');
    Route::get('question/data', 'QuestionController@data')->name('questionData');
    Route::get('question/add/{id}', 'QuestionController@add')->name('questionAdd');
    Route::post('question/save/{id}', 'QuestionController@save')->name('questionSave');
    Route::get('question/delete/{id}', 'QuestionController@delete')->name('deleteQuestion');
    Route::get('question/edit/{id}/{setId}', 'QuestionController@edit')->name('editQuestion');
    Route::post('question/update', 'QuestionController@update')->name('questionUpdate');

    // Pratice Question
    Route::get('praticequestion/data/{id}', 'PraticeQuestionController@index')->name('praticequestion');
    Route::get('praticequestion/data', 'PraticeQuestionController@data')->name('praticequestionData');
    Route::get('praticequestion/add/{id}', 'PraticeQuestionController@add')->name('praticequestionAdd');
    Route::post('praticequestion/save/{id}', 'PraticeQuestionController@save')->name('praticequestionSave');
    Route::get('praticequestion/delete/{id}', 'PraticeQuestionController@delete')->name('deletePraticequestion');
    Route::get('praticequestion/edit/{id}/{setId}', 'PraticeQuestionController@edit')->name('editPraticequestion');
    Route::post('praticequestion/update', 'PraticeQuestionController@update')->name('praticequestionUpdate');

      // Match Making
      Route::get('matchmaking/data/{id}', 'MatchMakingController@index')->name('matchmaking');
      Route::get('matchmaking/data', 'MatchMakingController@data')->name('matchmakingData');
      Route::get('matchmaking/add/{id}', 'MatchMakingController@add')->name('matchmakingAdd');
      Route::post('matchmaking/save/{id}', 'MatchMakingController@save')->name('matchmakingSave');
      Route::get('matchmaking/delete/{id}', 'MatchMakingController@delete')->name('deletematchmaking');
      Route::get('matchmaking/edit/{id}/{setId}', 'MatchMakingController@edit')->name('editmatchmaking');
      Route::post('matchmaking/update', 'MatchMakingController@update')->name('matchmakingUpdate');
    // Notification
    Route::get('notification', 'NotificationController@index')->name('notification');
    Route::get('notification/data', 'NotificationController@data')->name('notificationData');
    Route::get('notification/add', 'NotificationController@add')->name('notificationAdd');
    Route::get('notification/delete/{id}', 'NotificationController@delete')->name('deleteNotification');
    Route::post('notification/save', 'NotificationController@save')->name('notificationSave');
    Route::get('notification/setting', 'NotificationController@setting')->name('notificationSetting');
    Route::post('notification/setting/add', 'NotificationController@settingsave')->name('notificationSettingsave');

    // Pratice Question Import
    Route::get('importpraticequestion', 'PraticeQuestionImportController@index')->name('praticequestionimport');
    Route::get('praticequestionexport', 'PraticeQuestionImportController@export')->name('praticequestion_export');
    Route::post('praticequestionimport', 'PraticeQuestionImportController@import')->name('praticequestion_import');
    
    // Pratice Leaderboard
    Route::get('praticeleaderboard', 'PraticeLeaderboardController@index')->name('praticeleaderboard');
    Route::get('praticeleaderboard/data/{type}', 'PraticeLeaderboardController@data')->name('praticeleaderboardData');

    // Withdrawal
    Route::get('withdrawal', 'WithdrawalController@index')->name('withdrawal');
    Route::get('withdrawal/data', 'WithdrawalController@data')->name('withdrawalData');
    Route::post('withdrawal/data/update/{id}', 'WithdrawalController@update')->name('withdrawalUpdate');

    // General Setting
    Route::get('generalsetting', 'General_Setting_Controller@index')->name('generalsetting');
    Route::post('generalsetting/earning', 'General_Setting_Controller@earning_setting')->name('generalsettingearning_setting');
    Route::post('generalsetting/setearningpoint', 'General_Setting_Controller@setearningpoint')->name('generalsettingsetearningpoint');
    Route::post('generalsetting/spinwheelpoint', 'General_Setting_Controller@spinwheelpoint')->name('generalsettingspinwheelpoint');
    Route::post('generalsetting/dailyloginpoint', 'General_Setting_Controller@dailyloginpoint')->name('generalsettingdailyloginpoint');
    Route::post('generalsetting/getfreecongpoint', 'General_Setting_Controller@getfreecongpoint')->name('generalsettinggetfreecongpoint');

    // Question Import (Master)
    Route::get('importquestion', 'QuestionImportController@index')->name('questionimport');
    Route::get('questionexport', 'QuestionImportController@export')->name('question_export');
    Route::post('questionimport', 'QuestionImportController@import')->name('question_import');

    // Question Leaderboard
    Route::get('questionleaderboard', 'QuestionLeaderboardController@index')->name('questionleaderboard');
    Route::get('questionleaderboard/data/{type}', 'QuestionLeaderboardController@data')->name('questionleaderboardData');

    // Setting (master)
    Route::get('setting', 'SettingController@index')->name('setting');
    Route::get('setting/smtp', 'SettingController@smtpindex')->name('settingsmtpindex');
    Route::post('setting/app', 'SettingController@app')->name('settingapp');
    Route::post('setting/changepassword', 'SettingController@changepassword')->name('settingchangepassword');
    Route::post('setting/payment', 'SettingController@payment')->name('settingpayment');
    Route::post('setting/smtp', 'SettingController@smtp')->name('settingsmtp');
    Route::post('setting/currency', 'SettingController@currency')->name('settingcurrency');
    Route::post('setting/admob', 'SettingController@admob_android')->name('settingadmob_android');
    Route::post('setting/admob-ios', 'SettingController@admob_ios')->name('settingadmob_ios');
    Route::post('setting/facebookad', 'SettingController@facebookad')->name('settingfacebookad');
    Route::post('setting/facebookad-ios', 'SettingController@facebookad_ios')->name('settingfacebookad_ios');
    Route::post('setting/purchasecode', 'SettingController@purchasecode')->name('settingpurchasecode');

    // Language
    Route::get('language/{id}', 'AdminController@language')->name('language');

});
