@extends('admin.layouts.master')
@section('title', __('Label.Withdrawal Request'))
@section('content')
 
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-12">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Label.Withdrawal Request')}}
            </li>
          </ol>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped withdrawal-table text-center table-bordered" id="withdrawal-table">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
              <th> {{__('Label.Name')}} </th>
              <th> {{__('Label.Point')}} </th>
              <th> {{__('Label.Amount')}} </th>
              <th> {{__('Label.Type')}} </th>
              <th> {{__('Label.Detail')}} </th>
              <th> {{__('Label.Date')}} </th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.withdrawal-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          stateSave: true,
          serverSide: false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          order: [ [0, 'desc'] ],
          ajax: "{{ route('withdrawalData') }}",
          columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'fullname', name:'fullname'},
            {data: 'point', name: 'point'},
            {data: 'total_amount', name: 'total_amount'},
            {data: 'payment_type', name: 'payment_type'}, 
            {data: 'payment_detail', name: 'payment_detail'}, 
            {data: 'date', name: 'date'}, 
            {data: 'action', name: 'action'},
          ],
        });
      });
    });
  </script>
  <script type="text/javascript">

    $(document).ready(function() {
      $('#withdrawal-table').on('click', 'button', function() {
        var id = $(this).data('id');
        var status = $(this).data('status');

        var url = "{{route('withdrawalUpdate', '')}}"+"/"+id;
        $.ajax({
            type: "POST",
            url: url,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            data:id,
            success:function(resp){
              get_responce_message(resp, 'update_status', '{{ route("withdrawal") }}');
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
              toastr.error(errorThrown.msg,'failed');         
            }
        });
      });
    });
  </script>
@endpush