@extends('admin.layouts.master')
@section('title', __('Label.Edit Category'))
@section('content')

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item">
              <a href="{{ route('studyset') }}">{{__('Label.studyset')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
            Edit {{__('Label.studyset')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('studyset') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.Studyset')}}</a>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
      	<form enctype="multipart/form-data" id="save_edit_category">
      		@csrf
      		<div class="form-row">
      			<div class="col-md-12 mb-3">
      				<div class="form-group">
      					<label for="name">{{__('Label.NAME')}}</label>
      					<input name="name" type="text" class="form-control" id="name" value="{{$result->name}}">
      				</div>
      			</div>
      		</div>
          <div class="form-row">
    				<div class="col-md-6 mb-3">
    					<div class="form-group">
    						<label for="category_id">Category</label>
    						<select class="form-control" id="category_id" name="category_id">
    							<option value="">Select Category</option>
    							@foreach ($category as $key => $value)
    							<option value="{{ $value->id}}" {{ $result->category_id == $value->id  ? 'selected' : ''}}> 
    								{{ $value->name }} 
    							</option>
    							@endforeach  
    						</select>
    					</div>
    				</div>    			
    			</div>
          <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Status</label>
                        <select class="form-control status" id="status" name="status">
    							<option value="">Select</option>
    							
    							<option value="1"  {{ $result->status == 1 ? 'selected' : ''}} > 
    								Active 
    							</option>
                 <option value="0"  {{ $result->status == 0 ? 'selected' : ''}}> Inactive</option>
                
    							
    						</select>
                    </div>
                </div>
            </div>
			<div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">is Featured</label>
                        <select class="form-control status" id="featured" name="featured">
    							<option value="">Select</option>
    							
    							<option value="1"  {{ $result->featured == 1 ? 'selected' : ''}} > 
    								Yes 
    							</option>
                 <option value="0"  {{ $result->featured == 0 ? 'selected' : ''}}> No</option>
                
    							
    						</select>
                    </div>
                </div>
            </div>
                <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Reward Type</label>
                        <select class="form-control reward_type" id="reward_type" name="reward_type">
    							<option value="">Select</option>
    							
    							<option value="1"  {{ $result->reward_type == 1 ? 'selected' : ''}} > 
    								Primary 
    							</option>
                 <option value="2"  {{ $result->reward_type == 2 ? 'selected' : ''}}> Secondary</option>
                  <option value="3"  {{ $result->reward_type == 3 ? 'selected' : ''}}> None</option>
    							
    						</select>
                    </div>
                </div>
            </div>
            <div class="form-row option_class ">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Reward points</label>
                        <input name="reward_points" type="text" class="form-control" id="reward_points"
                            placeholder="Enter Reward points" value="{{$result->reward_points}}">
                    </div>
                </div>
            </div>
            <div class="form-row option_class">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Max Reward Per User</label>
                        <input name="max_userpoints" type="text" class="form-control" id="max_userpoints"
                            placeholder="Reward for user" value="{{$result->max_userpoints}}">
                    </div>
                </div>
            </div>
            <div class="form-row">
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<label for="image">Cover Image</label> 
    						<input type="file" class="form-control" id="cover_image" name="cover_image" > 
    						<label class="mt-1">{{__('Label.Note_Image')}}</label>
    					</div>
    				</div>
    				<div class="col-md-6"> 
    					<div class="form-group">
    						<div class="custom-file ml-5"> 
                <?php 
										if($result->cover_image){
											$app = URL::asset('/images/studyset').'/'.$result->cover_image;
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
    							<img  src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    						</div>
    					</div>
    				</div>
    			</div>
                <div class="form-row">
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<label for="image"> Image</label> 
    						<input type="file" class="form-control" id="main_image" name="main_image" > 
    						<label class="mt-1">{{__('Label.Note_Image')}}</label>
    					</div>
    				</div>
    				<div class="col-md-6"> 
    					<div class="form-group">
    						<div class="custom-file ml-5"> 
                <?php 
										if($result->main_image){
											$app = URL::asset('/images/studyset').'/'.$result->main_image;
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
    							<img  src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    						</div>
    					</div>
    				</div>
    			</div>
                <div class="form-row">
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<label for="image">Icon Image</label> 
    						<input type="file" class="form-control" id="icon_image" name="icon_image" > 
    						<label class="mt-1">{{__('Label.Note_Image')}}</label>
    					</div>
    				</div>
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<div class="custom-file ml-5"> 
    						<?php 
										if($result->icon_image){
											$app = URL::asset('/images/studyset').'/'.$result->icon_image;
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
    							<img  src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    						</div>
    					</div>
    				</div>
    			</div>

      		<div class="border-top mt-2 pt-3">
      			<input type="hidden" value="{{$result->id}}" name="id">
      			<button type="button" class="btn btn-default mw-120" onclick="save_edit_category()">{{__('Label.UPDATE')}}</button>
            <a href="{{route('category')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
      		</div>
      	</form>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
 <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">
    function save_edit_category(){
      $("#dvloader").show();
      var formData = new FormData($("#save_edit_category")[0]);
      $.ajax({
        type:'POST',
        url:'{{ route("studysetUpdate") }}',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_edit_category', '{{ route("studyset") }}');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
          toastr.error(errorThrown.msg,'failed');         
        }
      });
    }
    $(document).ready(function() {
			var myVal = {{ $result->reward_type}}
			if (myVal == 3) {
				$('.option_class').hide();
			
			} else {
				$('.option_class').show();
			
			}
		});
    $('.reward_type').on('change', function() {
  		if (this.value == 3) {
				$('.option_class').hide();
			} else {
				$('.option_class').show();
			}
});
  </script>
@endpush