
@extends('admin.layouts.master')
@section('title',  __('Flash Card'))
@section('content')
 
    <!-- Start:  Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>
      <h5>Study Set: {{$name}}</h5>
      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"> {{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              Flash Card
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center" style="margin-top:-14px">
          <a href="{{ route('setsAdd', ['id'=>$id]) }}" class="btn btn-default mw-120">add Flashcard</a>
        </div>
      </div>
      
      <div class="table-responsive">
        <table class="table table-striped category-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
              <th> Ques</th> 
              <th> Des</th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.category-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [ [0, 'asc'] ],
          ajax: "{{ route('setsData',['id'=>$id]) }}",
          columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            // { data: 'image', name: 'image', 
            //   "render": function (data, type, full, meta) {
            //     if(data){
            //       return "<img src='{{url('images/category/')}}/"+ data + "' height=50 width=50/>";
            //     } else {
            //       return "<img src='{{url('assets/imgs/1.png')}}' height=50 />";
            //     }
            //   },
            // },
            
            {data: 'question', name:'question'},
            {data: 'description', name:'description'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
  
@endpush

