@extends('admin.layouts.master')
@section('title', __('Label.Edit Pratice Question'))
@section('content')

    	<!-- Start: Body-Content -->
    	<div class="body-content">
    		<!-- mobile title -->
    		<h1 class="page-title-sm">@yield('title')</h1>
			<h5>Study Set: {{$name}}</h5>
    		<div class="border-bottom row mb-3">
    			<div class="col-sm-10">
    				<ol class="breadcrumb">
    			  		<li class="breadcrumb-item">
    						<a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
    					</li>
    					<li class="breadcrumb-item">
    						<a href="{{ route('praticequestion',['id'=>$setId]) }}">{{__('Label.Pratice Question')}}</a>
    					</li>
    					<li class="breadcrumb-item active" aria-current="page">
    						{{__('Label.Edit Pratice Question')}}
    					</li>
    				</ol>
    			</div>
    			<div class="col-sm-2 d-flex align-items-center">
    				<a href="{{ route('praticequestion',['id'=>$setId]) }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.Pratice Question')}}</a>
    			</div>
    		</div>

    		<div class="card custom-border-card mt-3">
    			<form enctype="multipart/form-data" id="save_edit_pratice_question">
    				{!! csrf_field() !!}
    			
    				<div class="form-row">
    					<div class="col-md-12 mb-3">
    						<div class="form-group">
    							<label for="question">{{__('Label.QUESTION')}}</label>
    							<textarea class="form-control" id="question" rows="4" name="question">{{$result->question}}</textarea>
    						</div>
    					</div>
    				</div>
					<div class="form-row option_class1">
    				<div class="col-md-12 mb-3">
    					<div class="form-group">
    						<label for="term">Term</label>
    						<input class="form-control"   id="term" value="{{$result->term}}"   name="term"/>
    					</div>
    				</div>
    				</div>
    				<div class="form-row">
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<label for="image">{{__('Label.IMAGE')}}</label>
    							<input type="file" class="form-control" id="image" name="image" value="{{$result->image}}">
    							<label class="mt-1">{{__('Label.Note_Image')}}</label>
    						</div>
    					</div>
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<div class="custom-file ml-5">
    								<?php 
										if($result->image){
											$app = URL::asset('/images/pratice_question').'/'.$result->image; 
										} else {
											$app = URL::asset('/assets/imgs/1.png');
										}
									?>
    								<img  src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    								<input type="hidden" name="old_image" value="{{$result->image}}">
    							</div>
    						</div>
    					</div>
    				</div>
    				<div class="form-row">
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<label for="question_type">{{__('Label.QUESTION TYPE')}}</label>
    							<span class="border col-md-3 p-2 m-4">
    								<input type="radio" value="1" id="question_type" name="question_type" class="question_type" {{ ($result->question_type) == '1' ? 'checked' : '' }}>
									<label for="question_type">{{__('Label.Options')}}</label>
    							</span>
    							<span class="border col-md-3 p-2">
    								<input type="radio" value="2" name="question_type" class="question_type" {{ ($result->question_type) == '2' ? 'checked' : '' }}>  
									<label for="question_type">{{__('Label.True/False')}}</label>
    							</span>
    						</div>
    					</div>
    				</div>
    				<div class="form-group row">
    					<div class="col-sm-1"></div>
    					<div class="col-sm-5">
    						<label class="form-check-input">{{__('Label.A')}}</label> <input type="text" value="{{$result->option_a}}" name="option_a" class="form-control" id="option_a">
    					</div>
    					<div class="col-sm-5">
    						<label class="form-check-input">{{__('Label.B')}}</label> <input type="text" value="{{$result->option_b}}" name="option_b" class="form-control" id="option_b">
    					</div>
    				</div>
    				<div class="form-group row option_class">
    					<div class="col-sm-1"></div>
    					<div class="col-sm-5">
    						<label class="form-check-input">{{__('Label.C')}}</label> <input type="text" value="{{$result->option_c}}" name="option_c" class="form-control" id="option_c">
    					</div>
    					<div class="col-sm-5">
    						<label class="form-check-input">{{__('Label.D')}}</label> <input type="text" value="{{$result->option_d}}" name="option_d" class="form-control" id="option_d">
    					</div>
    				</div>
    				<div class="form-row">
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<label for="level_id">{{__('Label.LEVEL')}}</label>
    							<select class="form-control" id="level_id" name="level_id">
    								<option value="">{{__('Label.Select Level')}}</option>
    								@foreach ($level as $key => $value)
    								<option value="{{ $value->id}}" {{ $result->level_id == $value->id  ? 'selected' : ''}}> 
    									{{ $value->name }} 
    								</option>
    								@endforeach  
    							</select>
    						</div>
    					</div>
    					<div class="col-md-6 mb-3">
    						<div class="form-group">
    							<label for="answer">{{__('Label.ANSWER')}}</label>
    							<select class="form-control" id="answer" name="answer">
    								<option value="">{{__('Label.Select Right Answer')}}</option>
    								<option value="1" {{ ($result->answer) == '1' ? 'selected' : '' }}> {{__('Label.A')}} </option>
    								<option value="2" {{ ($result->answer) == '2' ? 'selected' : '' }}> {{__('Label.B')}} </option>
    								<option value="3" {{ ($result->answer) == '3' ? 'selected' : '' }} class="option_class"> {{__('Label.C')}} </option>
    								<option value="4" {{ ($result->answer) == '4' ? 'selected' : '' }} class="option_class"> {{__('Label.D')}} </option>
    							</select>
    						</div>
    					</div>
    				</div>
    			
    				<div class="border-top mt-2 pt-3">
    					<input type="hidden" value="{{$result->id}}" name="id">
    					<button type="button" class="btn btn-default mw-120" onclick="save_edit_pratice_question()">{{__('Label.UPDATE')}}</button>
    					<a href="{{route('praticequestion',['id'=>$setId])}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
    				</div>
    			</form>
    		</div>
    	</div>
    	<!-- End: Body-Content -->
    </div>
    <!-- End: Right Contenct -->
@endsection

@push('scripts')
    <script type="text/javascript">

		function save_edit_pratice_question(){
			$("#dvloader").show();
			var formData = new FormData($("#save_edit_pratice_question")[0]);
			$.ajax({
				type:'POST',
				url:'{{ route("praticequestionUpdate") }}',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_edit_pratice_question', '{{ route("praticequestion",["id"=>$setId]) }}');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}
		$(document).ready(function() {
			var myVal = {{ $result->question_type}}
			if (myVal == 2) {
				$('.option_class').hide();
				$('.option_class1').show();
			} else {
				$('.option_class').show();
				$('.option_class1').hide();
			}
		});
		$('.question_type').on('click', function() {

			var question_type = $('input[name=question_type]:checked').val()
			if (question_type == 1) {
				$('.option_class').show();
				$('.option_class1').hide();
			} else {
				$('.option_class').hide();
				$('.option_class1').show();
			}
		})
    </script>


@endpush