@extends('admin.layouts.master')
@section('title', __('Label.Edit User'))
@section('content')
 	
  		<!-- Start: Body-Content -->
  		<div class="body-content">
  			<!-- mobile title -->
  			<h1 class="page-title-sm">@yield('title')</h1>

  			<div class="border-bottom row mb-3">
  				<div class="col-sm-10">
  					<ol class="breadcrumb">
  						<li class="breadcrumb-item">
  							<a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
  						</li>
  						<li class="breadcrumb-item">
  							<a href="{{ route('user') }}">{{__('Label.Users')}}</a>
  						</li>
  						<li class="breadcrumb-item active" aria-current="page">
  							{{__('Label.Edit User')}}
  						</li>
  					</ol>
  				</div>
  				<div class="col-sm-2 d-flex align-items-center">
  					<a href="{{ route('user') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.Users List')}}</a>
  				</div>
  			</div>

  			<div class="card custom-border-card mt-3">
  				<form enctype="multipart/form-data" id="save_edit_user">
  					@csrf
  					<div class="form-row">
  						<div class="col-md-4 mb-3">
  							<div class="form-group">
  								<label for="Inputtext1">{{__('Label.NAME')}}</label>
  								<input name="fullname" type="text" class="form-control" id="Inputtext1" value="{{$result->fullname}}">
  							</div>
  						</div>
  						<div class="col-md-4 mb-3">
  							<div class="form-group">
  								<label for="Inputtext2">{{__('Label.USER NAME')}}</label>
  								<input name="username" type="text" class="form-control" id="Inputtext2" value="{{$result->username}}">
  							</div>
  						</div>
  						<div class="col-md-4 mb-3">
  							<div class="form-group">
  								<label for="Inputnumber1">{{__('Label.MOBILE NUMBER')}}</label>
  								<input name="mobile_number" type="number" class="form-control" id="Inputnumber1" value="{{$result->mobile_number}}">
  							</div>
  						</div>
  					</div>
  					<div class="form-row">
  						<div class="col-md-6 mb-3">
  							<div class="form-group">
  								<label for="Inputemail1">{{__('Label.EMAIL')}}</label>
  								<input name="email" type="email" class="form-control" id="Inputemail1" value="{{$result->email}}">
  							</div>
  						</div>
  						<div class="col-md-6 mb-3">
  							<div class="form-group">
  								<label for="InputPassword1">{{__('Label.PASSWORD')}}</label>
  								<input name="password" type="password" class="form-control" id="InputPassword1">
  							</div>
  						</div>
  					</div>
  					<div class="form-row">
  						<div class="col-md-6 mb-3">
  							<div class="form-group">
  								<label for="Inputtext3">{{__('Label.INSTAGRAM URL')}}</label>
  								<input name="instagram_url" type="text" class="form-control" id="Inputtext3" value="{{$result->instagram_url}}">
  							</div>
  						</div>
  						<div class="col-md-6 mb-3">
  							<div class="form-group">
  								<label for="Inputtext4">{{__('Label.FACEBOOK URL')}}</label>
  								<input name="facebook_url" type="text" class="form-control" id="Inputtext4" value="{{$result->facebook_url}}">
  							</div>
  						</div>
  					</div>
  					<div class="form-row">
  						<div class="col-md-6 mb-3">
  							<div class="form-group">
  								<label for="Inputtext5">{{__('Label.TWITTER URL')}}</label>
  								<input name="twitter_url" type="text" class="form-control" id="Inputtext5" value="{{$result->twitter_url}}">
  							</div>
  						</div>
  						<div class="col-md-6 mb-3">
  							<div class="form-group">
  								<label for="Inputtext6">{{__('Label.BIO DATA')}}</label>
  								<input name="biodata" type="text" class="form-control" id="Inputtext6" value="{{$result->biodata}}">
  							</div>
  						</div>
  					</div>
  					<div class="form-row">
  						<div class="col-md-6 mb-3"> 
  							<div class="form-group"> 
  								<label for="profile_img">{{__('Label.IMAGE')}}</label> 
  								<input type="file" class="form-control" id="profile_img" name="profile_img" value="{{$result->profile_img}}"> 
  								<label class="mt-1">{{__('Label.Note_Image')}}</label>
  							</div>
  						</div>
  						<div class="col-md-6">
  							<div class="form-group">
  								<div class="custom-file ml-5">
  									<?php 
										if($result->profile_img){
											$app = URL::asset('/images/user').'/'.$result->profile_img; 
										} else {
											$app = URL::asset('/assets/imgs/1.png'); 
										}
									?>
  									<img  src="{{$app}}" height="120px" width="120px" id="preview-image-before-upload">
  									<input type="hidden" name="old_profile_img" value="{{$result->profile_img}}">
  								</div>
  							</div>
  						</div>
  					</div>
  					<div class="border-top pt-3">
  						<input type="hidden" value="{{$result->id}}" name="id">
  						<button type="button" class="btn btn-default mw-120" onclick="save_edit_user()">{{__('Label.UPDATE')}}</button>
  						<a href="{{route('user')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
  					</div>
  				</form>
  			</div>
  		</div>
  		<!-- End: Body-Content -->
  	</div>
  	<!-- End: Right Contenct -->
@endsection

@push('scripts')
	<script type="text/javascript">

		function save_edit_user(){
			$("#dvloader").show();
			var formData = new FormData($("#save_edit_user")[0]);
			$.ajax({
				type:'POST',
				url:'{{ route("userUpdate") }}',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_edit_user', '{{ route("user") }}');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}

		$(document).ready(function (e) {

			$('#profile_img').change(function(){
				let reader = new FileReader();
				reader.onload = (e) => { 
					$('#preview-image-before-upload').attr('src', e.target.result); 
				}
				reader.readAsDataURL(this.files[0]); 

			});

		});
	</script>
@endpush