@extends('admin.layouts.master')
@section('title', __('Label.Add User'))
@section('content')
 
    <!-- Start: Body-Content -->
  	<div class="body-content">
  		<!-- mobile title -->
  		<h1 class="page-title-sm">@yield('title')</h1>

  		<div class="border-bottom row mb-3">
  			<div class="col-sm-10">
  				<ol class="breadcrumb">
  					<li class="breadcrumb-item">
  						<a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
  					</li>
  					<li class="breadcrumb-item">
  						<a href="{{ route('user') }}">{{__('Label.Users')}}</a>
  					</li>
  					<li class="breadcrumb-item active" aria-current="page">
  						{{__('Label.Add User')}}
  					</li>
  				</ol>
  			</div>
  			<div class="col-sm-2 d-flex align-items-center">
  				<a href="{{ route('user') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.Users List')}}</a>
  			</div>
  		</div>

  		<div class="card custom-border-card mt-3">
  			<form id="save_user" enctype="multipart/form-data">
  				@csrf
  				<div class="form-row">
  					<div class="col-md-4 mb-3">
  						<div class="form-group">
  							<label for="fullname">{{__('Label.NAME')}}</label>
  							<input name="fullname" type="text" class="form-control" id="fullname">
  						</div>
  					</div>
  					<div class="col-md-4 mb-3">
  						<div class="form-group">
  							<label for="username">{{__('Label.USER NAME')}}</label>
  							<input name="username" type="text" class="form-control" id="username">
  						</div>
  					</div>
  					<div class="col-md-4 mb-3">
  						<div class="form-group">
  							<label for="mobile_number">{{__('Label.MOBILE NUMBER')}}</label>
  							<input name="mobile_number" type="number" class="form-control" id="mobile_number">
  						</div>
  					</div>
  				</div>
  				<div class="form-row">
  					<div class="col-md-6 mb-3">
  						<div class="form-group">
  							<label for="email">{{__('Label.EMAIL')}}</label>
  							<input name="email" type="email" class="form-control" id="email">
  						</div>
  					</div>
  					<div class="col-md-6 mb-3">
  						<div class="form-group">
  							<label for="password">{{__('Label.PASSWORD')}}</label>
  							<input name="password" type="password" class="form-control" id="password">
  						</div>
  					</div>
  				</div>
  				<div class="form-row">
  					<div class="col-md-6 mb-3">
  						<div class="form-group">
  							<label for="instagram_url">{{__('Label.INSTAGRAM URL')}}</label>
  							<input name="instagram_url" type="text" class="form-control" id="instagram_url">
  						</div>
  					</div>
  					<div class="col-md-6 mb-3">
  						<div class="form-group">
  							<label for="facebook_url">{{__('Label.FACEBOOK URL')}}</label>
  							<input name="facebook_url" type="text" class="form-control" id="facebook_url">
  						</div>
  					</div>
  				</div>
  				<div class="form-row">
  					<div class="col-md-6 mb-3">
  						<div class="form-group">
  							<label for="twitter_url">{{__('Label.TWITTER URL')}}</label>
  							<input name="twitter_url" type="text" class="form-control" id="twitter_url">
  						</div>
  					</div>
  					<div class="col-md-6 mb-3">
  						<div class="form-group">
  							<label for="biodata">{{__('Label.BIO DATA')}}</label>
  							<input name="biodata" type="text" class="form-control" id="biodata">
  						</div>
  					</div>
  				</div>
  				<div class="form-row">
  					<div class="col-md-6"> 
  						<div class="form-group"> 
  							<label for="profile_img">{{__('Label.IMAGE')}}</label> 
  							<input type="file" class="form-control" id="profile_img" name="profile_img" > 
  							<label class="mt-1">{{__('Label.Note_Image')}}</label>
  						</div>
  					</div>
  					<div class="col-md-6"> 
  						<div class="form-group">
  							<div class="custom-file ml-5"> 
  								<?php $app = URL::asset('/assets/imgs/1.png') ?>
  								<img  src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
  							</div>
  						</div>
  					</div>
  				</div>
  				<div class="border-top pt-3">
  					<button type="button" class="btn btn-default mw-120" onclick="save_user()">{{__('Label.SAVE')}}</button>
  					<a href="{{route('user')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
  				</div>
  			</form>
  		</div>
  	</div>
  	<!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
	<script type="text/javascript">

		function save_user(){
			$("#dvloader").show();
			var formData = new FormData($("#save_user")[0]);
			$.ajax({
				type:'POST',
				url:'{{ route("userSave") }}',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_user', '{{ route("user") }}');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}
	
		$(document).ready(function (e) {

			$('#profile_img').change(function(){
				let reader = new FileReader();
				reader.onload = (e) => { 
					$('#preview-image-before-upload').attr('src', e.target.result); 
				}
				reader.readAsDataURL(this.files[0]); 
			});

		});
	</script>
@endpush
