@extends('admin.layouts.master')
@section('title', __('Label.Add User'))
@section('content')
 
    <!-- Start: Body-Content -->
  	<div class="body-content">
  		<!-- mobile title -->
  		<h1 class="page-title-sm">@yield('title')</h1>

  		<div class="border-bottom row mb-3">
  			<div class="col-sm-10">
  				<ol class="breadcrumb">
  					<li class="breadcrumb-item">
  						<a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
  					</li>
  					<li class="breadcrumb-item">
  						<a href="{{ route('pages') }}">{{__('Pages')}}</a>
  					</li>
  					<li class="breadcrumb-item active" aria-current="page">
  						{{__('Add Page')}}
  					</li>
  				</ol>
  			</div>
  			<div class="col-sm-2 d-flex align-items-center">
  				<a href="{{ route('pages') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Pages List')}}</a>
  			</div>
  		</div>

  		<div class="card custom-border-card mt-3">
  			<form id="save_user" enctype="multipart/form-data">
  				@csrf
  				<div class="form-row">
  					<div class="col-md-4 mb-3">
  						<div class="form-group">
  							<label for="page">{{__('Page Name')}}</label>
  							<input name="page" type="text" class="form-control" id="fullname" readonly>
  						</div>
  					</div>
  					<div class="col-md-12 mb-3">
  						<div class="form-group">
  							<label for="content">Content</label>
  							<textarea name="content"  class="form-control ckeditor"  rows="4"  id="content"> </textarea>
  						</div>
  					</div>
  					
  				</div>
  				
  				<div class="border-top pt-3">
  					<button type="button" class="btn btn-default mw-120" onclick="save_user()">{{__('Label.SAVE')}}</button>
  					<a href="{{route('pages')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
  				</div>
  			</form>
  		</div>
  	</div>
  	<!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
<script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
       $('.ckeditor').ckeditor();
    });
</script>
	<script type="text/javascript">

		function save_user(){
			$("#dvloader").show();
			var formData = new FormData($("#save_user")[0]);
			$.ajax({
				type:'POST',
				url:'{{ route("pagesSave") }}',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_user', '{{ route("pages") }}');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}
	
		$(document).ready(function (e) {

			$('#profile_img').change(function(){
				let reader = new FileReader();
				reader.onload = (e) => { 
					$('#preview-image-before-upload').attr('src', e.target.result); 
				}
				reader.readAsDataURL(this.files[0]); 
			});

		});
	</script>
@endpush
