@extends('admin.layouts.master')
@section('title', __('Match'))
@section('content')
 
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>
      <h5>Study Set: {{$name}}</h5>
      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Match')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('matchmakingAdd', ['id'=>$id]) }}" class="btn btn-default mw-150" style="margin-top:-14px">{{__('Add Match')}}</a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped praticequestion-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
            
              <th> Studyset Name </th>
              <th> {{__('Label.Question')}} </th>       
           
           
              <th> {{__('Label.Answer')}} </th>
              <th width="70px"> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.praticequestion-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          order: [ [0, 'asc'] ],
          ajax: "{{ route('matchmakingData',['id'=>$id]) }}",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
         
          {data: 'studyset.name', name: 'studyset.name'},
          {data: 'question', name:'question'},
         
         
       
          { data: 'answer', name: 'answer', 
          
          },  
          {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
@endpush
