@extends('admin.layouts.master')
@section('title', __('Label.Edit Category'))
@section('content')

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">FAQ</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item">
              <a href="{{ route('faq') }}">Faq</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
            Edit Faq
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('faq') }}" class="btn btn-default mw-120" style="margin-top:-14px">faq</a>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
      	<form enctype="multipart/form-data" id="save_edit_category">
      		@csrf
			  <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Question</label>
                        <input name="question" type="text" class="form-control" id="question" value="{{$result->question}}"  placeholder="Question">
                    </div>
                </div>
            </div>
             
               
             

                <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Answer</label>
                        <textarea name="answer"  rows=4 class="form-control" id="answer"
                            >{{$result->answer}} </textarea>
                    </div>
                </div>
            </div>
      		
			
				<div class="border-top mt-2 pt-3">
      			<input type="hidden" value="{{$result->id}}" name="id">
      			<button type="button" class="btn btn-default mw-120" onclick="save_edit_category()">{{__('Label.UPDATE')}}</button>
            <a href="{{route('faq')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
      		</div>
      	
		</form>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
 <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">
    function save_edit_category(){
      $("#dvloader").show();
      var formData = new FormData($("#save_edit_category")[0]);
      $.ajax({
        type:'POST',
        url:'{{ route("faqUpdate") }}',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_edit_category', '{{ route("faq") }}');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
          toastr.error(errorThrown.msg,'failed');         
        }
      });
    }
   
  </script>
@endpush