<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use DataTables, URL, DB;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;

class WithdrawalController extends Controller
{
    public function index()
    {
        try{
            return view('admin.withdrawal.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try{
            if ($request==true) {

                $users = Withdrawal::join('users', 'users.id', '=', 'withdrawal_request.user_id')
                    ->select('withdrawal_request.*', 'users.fullname')->get();

                return DataTables()::of($users)
                ->addIndexColumn()
                ->editColumn('date', function ($request) {
                    return $request->created_at->format('Y-m-d');
                })           
                ->addColumn('action', function($row){
                    if($row->status == 1){
                        return "<form id='update_status'>
                                    <button type='button' class='btn text-white p-1' style='background:#15ca20; font-size:14px; font-weight:bold;' data-id='$row->id' data-status='$row->status'>COMPLETED</button>
                                </form>";
                    } else {
                        return "<form id='update_status'>
                                    <button type='button' class='btn text-white pl-3 pt-1 pr-3 pb-1' style='background:#0dceec; font-size:14px; font-weight:bold; letter-spacing:0.1px;' data-id='$row->id' data-status='$row->status'>PENDING</button>
                                </form>";
                    }
                })
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.withdrawal.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update($id, Request $request)
    {
        try{
            $data = Withdrawal::where('id',$id)->first();
            if($data->status == 0){
                $data->status = 1;
            }elseif($data->status == 1) {
                $data->status = 0;
            }else {
                $data->status = 0;
            }
            $data->save();
            return response()->json(array('status' => 200, 'success'=> 'Status Changed'));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

} 