<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use DataTables, URL, DB;
use App\Models\Question;
use App\Models\Category;
use App\Models\StudySet;
use App\Models\Sets;
use Illuminate\Http\Request;
use App\Models\Pratice_Question;
use App\Models\Pratice_Leaderborad;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Services\PayUService\Exception;

class SetsController extends Controller
{
    private $folder = "/sets";
    
    public function index($id)
    {
        $set=StudySet::where('id', $id)->first();
      
        try {
            return view('admin.sets.index')->with(['id'=>$id,  'name'=>$set->name]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add($id)
    { 
      $set=StudySet::where('id', $id)->first();
    
        try {
            return view('admin.sets.add')->with(['id'=> $id,
        
        'name'=>$set->name
        ]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request, $id)
    {
        try {
            $validator = Validator::make($request->all(),[
                'image' => 'file|mimes:jpeg,png,jpg',
                'image1' => 'file|mimes:jpeg,png,jpg',
                // 'description' => 'required|min:2',
                // 'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else{

             
               
                    $user = new Sets();
                    $user->question = $request->question;   
                    $user->description = $request->description;   
                    $user->studyset_id = $id;
                 
                    $org_name = $request->file('image');
                    if ($org_name !=null) {
                        $user->image = saveImage($org_name,$this->folder);
                    }

                if($user->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_studyset') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_studyset')));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try {
            if ($request==true) {
                $data = Sets::where('studyset_id', $request->id)->select('*');
                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('descrption', function($row){
                   
                    return $row->descrption;
                })
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editsets",["id"=>$row->id ,"setId"=>$row->studyset_id]).'" class="btn"><img src="'.url("assets/imgs/edit.png").'"/></a> ';
                    $btn .= '<a href="'.route("deletesets",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action','description'])
                ->make(true);
            } else{     
                return view('admin.sets.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try{
            $category = Sets::where('id',$id)->first();
            // $question = Question::where('category_id',$id)->first();
            // $pratice_question = Pratice_Question::where('category_id',$id)->first();
            // $pratice_leaderborad = Pratice_Leaderborad::where('category_id','$id')->first();

            // if ($question) {
            //     return back()->with('error', __('Label.This Category is used on some other table so you can not remove it.'));
            // } elseif ($pratice_leaderborad) {
            //     return back()->with('error', __('Label.This Category is used on some other table so you can not remove it.'));      
            // } elseif ($pratice_question) {
            //     return back()->with('error', __('Label.This Category is used on some other table so you can not remove it.'));      
            // } else {
                if($category->delete()){
                    if($category->image){
                   @unlink("images/sets/".$category->image);    
                    }
                    if($category->image1){
                   @unlink("images/sets/".$category->image1);       
                    }   
                   return back()->with('error', __('Set Delete Successfully.'));
                }
            // }
        } catch (Exception $e) {
            return redirect('sets')->with($e);
        }
    }
    public function edit(Request $request,$id , $setId)
    {
        try {
            $set=StudySet::where('id', $setId)->first();
            $user = Sets::where('id',$id)->first();
            return view('admin.sets.edit',['result'=>$user,
        'setId'=>$setId,
        'name'=>$set->name
        ]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try{       
            
           
            $validator = Validator::make($request->all(),[
               
                'image' => 'file|mimes:jpeg,png,jpg',
                'image1' => 'file|mimes:jpeg,png,jpg',
                
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
            
             
               
         
                $user = Sets::where('id',$request->id)->first();
                if (isset($user->id)) {
                    $user->question = $request->question;              
                    $user->studyset_id = $user->studyset_id;
                    $user->description = $request->description;
                   $org_name = $request->file('image');

                   if ($org_name !== null) {
                        $user->image = saveImage($org_name,$this->folder);
                        @unlink("images/sets/".$request->old_image);         
                    } else {
                        $user->image = $request->old_image;                    
                    }
                    $org_name1 = $request->file('image1');

                   if ($org_name1 !== null) {
                        $user->image1 = saveImage($org_name1,$this->folder);
                        @unlink("images/sets/".$request->old_image1);         
                    } else {
                        $user->image1 = $request->old_image1;                    
                    }
                    if($user->save()){
                        return response()->json(array('status' => 200, 'success'=>__('Label.success_edit_category')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Label.error_edit_category')));
                    }
                } 
            }
        } catch(Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}

