<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use App\Models\Earnpoints;
use DataTables, URL, DB;
use App\Models\Withdrawal;
use App\Models\Transaction;
use App\Models\Users;
use App\Models\StudySet;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Pratice_Leaderborad;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class PointsController extends Controller
{
    private $folder = "/user";

    public function index()
    {
        try{
            return view('admin.points.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {
        try{
            return view('admin.points.add');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {
        try {
            $validator = Validator::make($request->all(),[
                'fullname' => 'required',
                'username' => 'required|min:2',
                'mobile_number' => 'required',
                'email' => 'required|unique:Earnpoints',
                'password' => 'required',
                'profile_img' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {

                $user = new Earnpoints();
                $user->fullname = $request->fullname;
                $user->username = $request->username;
                $user->mobile_number = $request->mobile_number;
                $user->email = $request->email;
                $user->password = Hash::make($request->password);
                $user->c_date = now();
                if($request->instagram_url){
                    $instagram_url = $request->instagram_url;
                } else {
                    $instagram_url = "";
                }
                $user->instagram_url = $instagram_url;
                if($request->facebook_url){
                    $facebook_url = $request->facebook_url;
                } else {
                    $facebook_url = "";
                }
                $user->facebook_url = $facebook_url;
                if($request->twitter_url){
                    $twitter_url = $request->twitter_url;
                } else {
                    $twitter_url = "";
                }
                $user->twitter_url = $twitter_url;
                if($request->biodata){
                    $biodata = $request->biodata;
                } else {
                    $biodata = "";
                }
                $user->biodata = $biodata;
                $user->address = "";
                $user->reference_code = Str::random(14);
                $user->parent_reference_code = "";
                $user->pratice_quiz_score = 0;
                $user->total_score = 0;
                $user->total_points = 0;
                $user->device_token = "";                
                $org_name = $request->file('profile_img');
                $user->profile_img = saveImage($org_name,$this->folder);

                if($user->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_user') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_user') ));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try{
            if ($request==true) {
                $data = Earnpoints::select('*');
                return DataTables()::of($data)
                ->addIndexColumn()
                // ->addColumn('action', function($row){
                //     $btn = '<a href="'.route("editpoints",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'" /></a> ';
                //     $btn .= '<a href="'.route("deletepoints",$row->id).'" id="'.$row->id.'" onclick="return archiveFunction(this.id)"  class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                //     return $btn;
                // })
                ->addColumn('fullname', function($row){
                  $user=Users::where('id', $row->user_id)->first();
                  
                    return  $user !=null ?  $user->fullname : '';
                })
                ->addColumn('studysetname', function($row){
                    $study=StudySet::where('id', $row->studyset_id)->first();
                    
                      return $study->name;
                  })
                  ->addColumn('created_at', function($row){
                   $newDate = date("d-m-Y", strtotime($row->created_at));
                    
                      return $newDate;
                  })
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.points.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try {
           $user = Earnpoints::where('id',$id)->first();
           $pratice_leaderborad = Pratice_Leaderborad::where('user_id',$id)->first();
           $transaction = Transaction::where('user_id',$id)->first();
           $withdrawal = Withdrawal::where('user_id',$id)->first();

            if ($pratice_leaderborad !== null) {
                return back()->with('error', __('Label.This User is used on some other table so you can not remove it.'));
            } elseif ($transaction !== null) {
                return back()->with('error', __('Label.This User is used on some other table so you can not remove it.'));
            } elseif ($withdrawal !== null) {
                return back()->with('error', __('Label.This User is used on some other table so you can not remove it.'));
            } else {
                if($user->delete()){
                    @unlink("images/user/".$user->profile_img);        
	                return back();
                }  
            }
        } catch (Exception $e) {
            return redirect('user')->with($e);
        }
    }
    public function edit(Request $request,$id)
    {
        try{
            $user = Earnpoints::where('id',$id)->first();
            if(isset($user->id)){
                return view('admin.points.edit',['result'=>$user]);
            } else {
                return redirect()->route('home');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try {
            $validator = Validator::make($request->all(),[
                'fullname' => 'required|min:2',
                'username' => 'required|min:2',
                'email' => 'required',
                'mobile_number' => 'required',
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $user = Earnpoints::where('id',$request->id)->first();
                if (isset($user->id)) {

                    $user->fullname = $request->fullname;
                    $user->username = $request->username;
                    $user->mobile_number = $request->mobile_number;
                    $user->email = $request->email;
                    $user->is_updated = 1;
                    if($request->instagram_url){
                        $instagram_url = $request->instagram_url;
                    } else {
                        $instagram_url = "";
                    }
                    $user->instagram_url = $instagram_url;
                    if($request->facebook_url){
                        $facebook_url = $request->facebook_url;
                    } else {
                        $facebook_url = "";
                    }
                    $user->facebook_url = $facebook_url;
                    if($request->twitter_url){
                        $twitter_url = $request->twitter_url;
                    } else {
                        $twitter_url = "";
                    }
                    $user->twitter_url = $twitter_url;
                    if($request->biodata){
                        $biodata = $request->biodata;
                    } else {
                        $biodata = "";
                    }
                    $user->biodata = $biodata;

                    $org_name = $request->file('profile_img');
                    if ($org_name) {
                        $user->profile_img = saveImage($org_name,$this->folder);
                        @unlink("images/user/".$request->old_profile_img);         
                    } else {
                        $user->profile_img = $request->old_profile_img;                    
                    }

                    if($user->save()){
                        return response()->json(array('status' => 200, 'success'=> __('Label.success_edit_user')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Label.error_edit_user')));
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}
