<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ContestQuestionExport;
use App\Imports\ContestQuestionImport;
use App\Exports\MttRegistrationsExport;

class ContestQuestionImportController extends Controller
{
    public function index()
    {
        try{
            return view('admin.contest_question_import.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        } 
    }
    public function export(Request $request)
    {
        try{
            return Excel::download(new ContestQuestionExport, 'Data-Formate-Contest.csv');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function import(Request $request) 
    {   
        try {
            $validator = Validator::make($request->all(),[
                'import_file' => 'required|mimes:csv,txt',
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            }

            Excel::import(new ContestQuestionImport, $request->file('import_file'));
            return response()->json(array('status' => 200, 'success'=> "File Upload Successfully" ));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
}
