<?php

namespace App\Http\Controllers\Admin;
use Illuminate\Support\Str as str;
use Validator;  
use DataTables, URL, DB;
use App\Models\Question;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Models\Pratice_Question;
use App\Models\Pratice_Leaderborad;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Services\PayUService\Exception;

class CategoryController extends Controller
{
    private $folder = "/category";
    
    public function index()
    {
        try {
            return view('admin.category.index');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add()
    {
        try {
            return view('admin.category.add');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request)
    {
        try {
            


            $validator = Validator::make($request->all(),[
                'name' => 'required|unique:category',               
                'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else{
                $user = new Category();
                $user->name = $request->name;
                $user->slug= str::slug($request->name, '-');
                $org_name = $request->file('image');
                $user->image = saveImage($org_name,$this->folder);

                if($user->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_category') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_category')));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try {
            if ($request==true) {
                $data = Category::select('*');
                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editCategory",$row->id).'" class="btn"><img src="'.url("assets/imgs/edit.png").'"/></a> ';
                    $btn .= '<a href="'.route("deleteCategory",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
            } else{     
                return view('admin.category.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try{
            $category = Category::where('id',$id)->first();
            // $question = Question::where('category_id',$id)->first();
            // $pratice_question = Pratice_Question::where('category_id',$id)->first();
            // $pratice_leaderborad = Pratice_Leaderborad::where('category_id','$id')->first();

            // if ($question) {
            //     return back()->with('error', __('Label.This Category is used on some other table so you can not remove it.'));
            // } elseif ($pratice_leaderborad) {
            //     return back()->with('error', __('Label.This Category is used on some other table so you can not remove it.'));      
            // } elseif ($pratice_question) {
            //     return back()->with('error', __('Label.This Category is used on some other table so you can not remove it.'));      
            // } else {
                if($category->delete()){
                   @unlink("images/category/".$category->image);        
                   return back()->with('error', __('Category Delete Successfully.'));
                }
            // }
        } catch (Exception $e) {
            return redirect('category')->with($e);
        }
    }
    public function edit(Request $request,$id)
    {
        try {
            $user = Category::where('id',$id)->first();
            return view('admin.category.edit',['result'=>$user]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try{        
            $validator = Validator::make($request->all(),[
                'name' => 'required|unique:category,name,'.$request->id,                
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
            
                $user = Category::where('id',$request->id)->first();
                if (isset($user->id)) {
                   $user->name = $request->name;
                   $user->slug = str::slug($request->name, '-');
                   $org_name = $request->file('image');

                   if ($org_name !== null) {
                    if($user->image!=null){
                        @unlink("images/category/".$request->image);      
                       }
                        $user->image = saveImage($org_name,$this->folder);
                        
                    } 
                    if($user->save()){
                        return response()->json(array('status' => 200, 'success'=>__('Label.success_edit_category')));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=> __('Label.error_edit_category')));
                    }
                } 
            }
        } catch(Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }

}

