@extends('admin.layouts.master')
@section('title', __('Label.Question Leaderboard'))
@section('content')

    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-12">
          <ol class="breadcrumb">
            <li class="breadcrumb-item">
              <a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Label.Quiz Leaderboard')}}
            </li>
          </ol>
        </div>
      </div>

      <div class="border-bottom mb-3 pb-3">
        <form class="" action="{{ route('questionleaderboard')}}" method="GET">
          <div class="form-row">
            <div class="col-md-1 d-flex align-items-center">
              <label for="type">{{__('Label.SEARCH')}} :</label>
            </div>
            <div class="col-md-2">
              <div class="form-group">
                <select class="form-control" id="type" name="type">
                <option value="" disabled>{{__('Label.Select Type')}}</option>
                  <option value="today" @if(isset($_GET['type'])){{ $_GET['type'] == "today" ? 'selected' : ''}}  @endif > {{__('Label.Today')}} </option>
                  <option value="month" @if(isset($_GET['type'])){{ $_GET['type'] == "month" ? 'selected' : ''}}  @endif> {{__('Label.Month')}} </option>
                  <option value="all" @if(isset($_GET['type'])){{ $_GET['type'] == "all" ? 'selected' : ''}} @else selected @endif> {{__('Label.All')}} </option>
                </select>
              </div>
            </div>
            <div class="col-sm-2 ml-4">
              <button class="btn btn-default" type="submit"> {{__('Label.SEARCH')}} </button>
            </div>
          </div>
        </form>
      </div>
      
      <div class="table-responsive">
        <table class="table table-striped praticeleaderboard-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Image')}} </th>
              <th> {{__('Label.Name')}} </th>
              <th> {{__('Label.Score')}} </th>
              <th> {{__('Label.Rank')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
    <script type="text/javascript">

        $(document).ready(function() {
            $(function () {

              @if(isset($_GET['type']) != null)
                var type = '{{ $_GET['type'] }}'; 
              @else
                var type = "all";
              @endif

              var url = "{{route('questionleaderboardData', '')}}"+"/"+type;

              var table = $('.praticeleaderboard-table').DataTable({
                  "responsive": true,
                  "autoWidth": false,
                  lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
                  processing: true,
                  serverSide: false,
                  language: {
                    paginate: {
                      previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
                      next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
                    }
                  },
                  order: [ [0, 'desc'] ],
                  ajax: url,
                  columns: [
                    {data: 'users.profile_img', name:'users.profile_img',
                      "render": function (data, type, full, meta) {
                      if(data){
                        return "<img src='{{url('images/user/')}}/"+ data + "' height=50 width=70 />";
                      } else {
                        return "<img src='{{url('assets/imgs/1.png')}}' height=50 width=70 />";
                      }
                    },
                    },
                    {data: 'users.username', name: 'users.username',
                      "render": function (data, type, full, meta) {
                        if(data){
                          return data;
                        } else {
                          return "-";
                        }
                      }
                    },
                    {data: 'total_score', name: 'total_score'},
                    {data: 'rank', name: 'rank'},
                  ],
              });
            });
        });
    </script>
@endpush
