@extends('admin.layouts.master')
@section('title', __('Label.Import Pratice Questions'))
@section('content')
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a></li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Label.Import Pratice Questions')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('praticequestion') }}" class="btn btn-default mw-120"style="margin-top:-14px;">{{__('Label.Pratice Question')}}</a>
        </div>
      </div>

      <div class="card custom-border-card mt-3">
        <form enctype="multipart/form-data" id="save_pratice_question_import" >
          @csrf
          <div class="form-row">
            <div class="col-md-1"></div>
            <div class="col-md-6 mb-3">
              <div class="form-group">
                <label for="import_file">{{__('Label.CSV QUESTIONS FILE')}}</label>
                <input type="file" class="form-control" id="import_file" name="import_file" >
              </div>
            </div>
          </div>
          <div class="border-top mt-2 pt-3">
            <button type="button" class="btn btn-default mw-120 ml-5" onclick="save_pratice_question_import()">{{__('Label.UPLOAD CSV FILE')}}</button>
            <a class="btn btn-warning ml-5" href="{{ route('praticequestion_export') }}">{{__('Label.DOWNLOAD SAMPLE FILE HERE')}}</a>
          </div>
        </form>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
	<script type="text/javascript">

		function save_pratice_question_import(){
      $("#dvloader").show();
			var formData = new FormData($("#save_pratice_question_import")[0]);
			$.ajax({
				type:'POST',
        url:'{{ route("praticequestion_import") }}',
        data:formData,
        cache:false,
        contentType: false,
        processData: false,
        success:function(resp){
          $("#dvloader").hide();
          get_responce_message(resp, 'save_pratice_question_import', '{{ route("praticequestionimport") }}');
        },
        error: function(XMLHttpRequest, textStatus, errorThrown) {
          $("#dvloader").hide();
        	toastr.error(errorThrown.msg,'failed');         
        }
      });
		}
	</script>
@endpush