
<?php $__env->startSection('title', __('Label.Add Question')); ?>
<?php $__env->startSection('content'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <!-- Start: Body-Content -->
    <div class="body-content"> 
    	<!-- mobile title -->
    	<h1 class="page-title-sm"><?php echo $__env->yieldContent('title'); ?></h1>
		<h5>Study Set: <?php echo e($name); ?></h5>
    	<div class="border-bottom row mb-3">
    		<div class="col-sm-10">
    			<ol class="breadcrumb">
    				<li class="breadcrumb-item">
    					<a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a>
    				</li>
    				<li class="breadcrumb-item">
    					<a href="<?php echo e(route('question', ['id'=>$id])); ?>"><?php echo e(__('Label.Question')); ?></a>
    				</li>
    				<li class="breadcrumb-item active" aria-current="page">
    					<?php echo e(__('Label.Add Question')); ?>

    				</li>
    			</ol>
    		</div>
    		<div class="col-sm-2 d-flex align-items-center">
    			<a href="<?php echo e(route('question', ['id'=>$id])); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('Label.Question')); ?></a>
    		</div>
    	</div>

    	<div class="card custom-border-card mt-3">
    		<form enctype="multipart/form-data" id="save_question">
    			<?php echo csrf_field(); ?>

    			
				
    			<div class="form-row">
    				<div class="col-md-12 mb-3">
    					<div class="form-group">
    						<label for="question"><?php echo e(__('Label.QUESTION')); ?></label>
    						<textarea class="form-control" id="question" rows="4" name="question"></textarea>
    					</div>
    				</div>
    			</div>
    			<div class="form-row">
    				<div class="col-md-6"> 
    					<div class="form-group"> 
    						<label for="image"><?php echo e(__('Label.IMAGE')); ?></label> 
    						<input type="file" class="form-control" id="image" name="image" > 
    						<label class="mt-1"><?php echo e(__('Label.Note_Image')); ?></label>
    					</div>
    				</div>
    				<div class="col-md-6"> 
    					<div class="form-group">
    						<div class="custom-file ml-5"> 
    							<?php $app = URL::asset('/assets/imgs/1.png') ?>
    							<img  src="<?php echo e($app); ?>" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
    						</div>
    					</div>
    				</div>
    			</div>
    			<div class="form-row">
    				<div class="col-md-6 mb-3">
    					<div class="form-group">
    						<label for="question_type"><?php echo e(__('Label.QUESTION TYPE')); ?></label>
    						<span class="border col-md-3 p-2 m-4">
    							<input type="radio" value="1" checked="checked" id="question_type" name="question_type" class="question_type"> 	<label for="question_type"><?php echo e(__('Label.Options')); ?></label>
    						</span>
    						<span class="border col-md-3 p-2">
    							<input type="radio" value="2" name="question_type" class="question_type">  <label for="question_type"><?php echo e(__('Label.True/False')); ?></label>
    						</span>
    					</div>
    				</div>
    			</div>
    			<div class="form-group row">
    				<div class="col-sm-1"></div>
    				<div class="col-sm-5">
    					<label class="form-check-input"><?php echo e(__('Label.A')); ?></label><input type="text" value="" name="option_a" class="form-control" id="option_a">
    				</div>
    				<div class="col-sm-5">
    					<label class="form-check-input"><?php echo e(__('Label.B')); ?></label><input type="text" value="" name="option_b" class="form-control" id="option_b">
    				</div>
    			</div>
    			<div class="form-group row option_class">
    				<div class="col-sm-1"></div>
    				<div class="col-sm-5">
    					<label class="form-check-input"><?php echo e(__('Label.C')); ?></label><input type="text" value="" name="option_c" class="form-control" id="option_c">
    				</div>
    				<div class="col-sm-5">
    					<label class="form-check-input"><?php echo e(__('Label.D')); ?></label><input type="text" value="" name="option_d" class="form-control" id="option_d">
    				</div>
    			</div>
    			<div class="form-row">
    				<div class="col-md-12 mb-3">
    					<div class="form-group">
    						<label for="answer"><?php echo e(__('Label.ANSWER')); ?></label>
    						<select class="form-control" id="answer" name="answer">
    							<option value=""><?php echo e(__('Label.Select Answer')); ?></option>
    							<option value="1"> <?php echo e(__('Label.A')); ?> </option>
    							<option value="2"> <?php echo e(__('Label.B')); ?> </option>
    							<option value="3" class="option_class"> <?php echo e(__('Label.C')); ?> </option>
    							<option value="4" class="option_class"> <?php echo e(__('Label.D')); ?> </option>
    						</select>
    					</div>
    				</div>
    			</div>
    			<div class="form-row">
    				<div class="col-md-12 mb-3">
    					<div class="form-group">
    						<label for="note"><?php echo e(__('Label.NOTE')); ?></label>
    						<textarea class="form-control" id="note" rows="2" name="note"></textarea>
    					</div>
    				</div>
    			</div>
    			<div class="border-top mt-2 pt-3">
    				<button type="button" class="btn btn-default mw-120" onclick="save_question()"><?php echo e(__('Label.SAVE')); ?></button>
    				<a href="<?php echo e(route('question', ['id'=>$id])); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
    			</div>
    		</form>
    	</div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
	<script type="text/javascript">

		function save_question(){
			$("#dvloader").show();
			var formData = new FormData($("#save_question")[0]);
			$.ajax({
				type:'POST',
				url:'<?php echo e(route("questionSave", ["id"=>$id])); ?>',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_question', '<?php echo e(route("question" ,["id"=>$id])); ?>');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}	
		$('.question_type').on('click', function() {
			var question_type = $('input[name=question_type]:checked').val()
			if (question_type == 1) {
				$('.option_class').show();
			} else {
				$('.option_class').hide();
			}
		})
	</script>
	
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/quiz/resources/views/admin/question_question/add.blade.php ENDPATH**/ ?>