@extends('admin.layouts.master')
@section('title', __('Label.Users List'))
@section('content')
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1> 

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Label.Users List')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('userAdd') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('Label.Add User')}}</a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped user-table text-center table-bordered example">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
              <th> {{__('Label.Image')}} </th>
              <th> {{__('Label.Full Name')}} </th>
              <th> {{__('Label.Email')}} </th>
              <th> {{__('Points')}} </th>
              <th> {{__('Label.Referal Code')}} </th>
              <th> {{__('Label.Type')}} </th>
              <th> {{__('Label.Date')}} </th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->

@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.user-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            },
            // multi Language Label Of Table
            // "sLengthMenu": "{{__('Label.Show')}}_MENU_{{__('Label.Entries')}} ",
            // "sProcessing": "{{__('Label.Processing')}}",
            // "sZeroRecords": "{{__('Label.No_data_available_in_table')}}",
            // "sSearch": "{{__('Label.Serach')}}",              
            // "sInfoEmpty": "{{__('Label.Showing_0_to_0_of_0_entries')}}",
            // "sInfo": "{{__('Label.Watch')}} _START_ {{__('Label.To')}} _END_ {{__('Label.Total')}} _TOTAL_ ",
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [0, 'desc'],
          ajax: "{{ route('userData') }}",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          { data: 'profile_img', name: 'profile_img', 
            "render": function (data, profile_img, full, meta) {
              if(data){
                return "<img src='{{url('images/user/')}}/"+ data + "' height=50 width=50 />";
              } else {
                return "<img src='{{url('assets/imgs/1.png')}}' height=50 width=50/>";
              }
            }, 
          },
          {data: 'fullname', name:'fullname',
            "render": function (data, fullname, full, meta) {
              if (data) {
                return data;
              } else {
                return "-";
              }
            }
          },
          {data: 'email', name: 'email',
            "render": function (data, email, full, meta) {
              if (data) {
                return data;
              } else {
               return "-";
              }
            }
          },
          {data: 'total_points', name: 'total_points',
            "render": function(data, total_points, full,meta) {
              if(data) {
                return data;
              } else {
                return "-";
              } 
            }
          },
          {data: 'reference_code', name: 'reference_code',
            "render": function(data, reference_code, full,meta) {
              if(data) {
                return data;
              } else {
                return "-";
              } 
            }
          },
          {data: 'type', name: 'type',
            "render": function(data, type, full,meta) {
              if(data == 1) {
                return "Normal";
              } else if(data == 2) {
                return "Scoial";
              } else if(data == 3) {
                return "OTP";
              }
            }
          },
          {data: 'created_at', name: 'created_at'}, 
          {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
  
  <script>
    function archiveFunction(id) {

      event.preventDefault(); // prevent form submit
      swal({
        title: "Are you sure?",
        text: "You will not be able to recover this Users!.",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#4e45b8",
        confirmButtonText: "YES, ARCHIVE IT!",
        cancelButtonText: "NO, CANCEL PLX!",
        closeOnConfirm: false,
        closeOnCancel: false
      },
      function(isConfirm){
        if (isConfirm) {
          let abc = "{{ URL('admin/user/delete') }}"+"/"+id;
          window.location.href = abc
        } else {
          swal("Cancelled", "Your imaginary file is safe :)", "error");
        }
      });
    }
  </script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
@endpush
