@extends('admin.layouts.master')
@section('title', __('Reward List'))
@section('content')
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">Reward list</h1> 

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Reward History')}}
            </li>
          </ol>
        </div>
       
      </div>

      <div class="table-responsive">
        <table class="table table-striped user-table text-center table-bordered example">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>
              <th> Name </th>
              <th> Study Set </th>
              <th> Points</th>
              <th> Type </th>         
              <th> {{__('Label.Date')}} </th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->

@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.user-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            },
            // multi Language Label Of Table
            // "sLengthMenu": "{{__('Label.Show')}}_MENU_{{__('Label.Entries')}} ",
            // "sProcessing": "{{__('Label.Processing')}}",
            // "sZeroRecords": "{{__('Label.No_data_available_in_table')}}",
            // "sSearch": "{{__('Label.Serach')}}",              
            // "sInfoEmpty": "{{__('Label.Showing_0_to_0_of_0_entries')}}",
            // "sInfo": "{{__('Label.Watch')}} _START_ {{__('Label.To')}} _END_ {{__('Label.Total')}} _TOTAL_ ",
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [0, 'desc'],
          ajax: "{{ route('pointsData') }}",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'fullname', name: 'fullname'},
          {data: 'studysetname', name: 'studysetname'},
          {data: 'points', name: 'points'},
          {data: 'type', name: 'type'},
          {data: 'created_at', name: 'created_at'}, 
          // {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
  
  <script>
    function archiveFunction(id) {

      event.preventDefault(); // prevent form submit
      swal({
        title: "Are you sure?",
        text: "You will not be able to recover this Users!.",
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#4e45b8",
        confirmButtonText: "YES, ARCHIVE IT!",
        cancelButtonText: "NO, CANCEL PLX!",
        closeOnConfirm: false,
        closeOnCancel: false
      },
      function(isConfirm){
        if (isConfirm) {
          let abc = "{{ URL('admin/user/delete') }}"+"/"+id;
          window.location.href = abc
        } else {
          swal("Cancelled", "Your imaginary file is safe :)", "error");
        }
      });
    }
  </script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
@endpush
