@extends('admin.layouts.master')
@section('title', __('Label.Subscription'))
@section('content')
  
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">@yield('title')</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('Label.Subscription')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
          <a href="{{ route('subscriptionAdd') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.Add Subscription')}}</a>
        </div>
      </div>

      <div class="table-responsive">
        <table class="table table-striped subscription-table text-center table-bordered">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> # </th>
              <th> {{__('Label.Name')}} </th>
              <th> {{__('Currency Type')}} </th>
              <th> {{__('Label.Price')}} </th>
              <th> {{__('Label.Coin')}} </th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.subscription-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [ [0, 'asc'] ],
          ajax: "{{ route('subscriptionData') }}",
          columns: [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'name', name:'name'},
          {data: 'currency_type', name: 'currency_type', visible: false,},
          {data: 'price', name: 'price',
            render: function (data, type, row, meta) {
              return row.currency_type + " " + row.price;
            }
          },
          {data: 'coin', name: 'coin'},
          {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
      });
    });
  </script>
@endpush
