@extends('admin.layouts.master')
@section('title', __('Add Match'))
@section('content')

    <!-- Start: Body-Content -->
    <div class="body-content">
    	<!-- mobile title -->
    	<h1 class="page-title-sm">@yield('title')</h1>
		<h5>Study Set: {{$name}}</h5>
    	<div class="border-bottom row mb-3">
    		<div class="col-sm-10">
    			<ol class="breadcrumb">
    				<li class="breadcrumb-item">
    					<a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
    				</li>
    				<li class="breadcrumb-item">
    					<a href="{{ route('matchmaking', ['id'=>$id]) }}">{{__('Match')}}</a>
    				</li>
    				<li class="breadcrumb-item active" aria-current="page">
    					{{__('Add Match')}}
    				</li>
    			</ol>
    		</div>
    		<div class="col-sm-2 d-flex align-items-center">
    			<a href="{{ route('matchmaking', ['id'=>$id]) }}"class="btn btn-default mw-120" style="margin-top:-14px">{{__('Match')}}</a>
    		</div>
    	</div>

    	<div class="card custom-border-card mt-3">
    		<form enctype="multipart/form-data" id="save_pratice_question">
    			{!! csrf_field() !!}
    			<div class="form-row">
    				<div class="col-md-12"> 
    					<div class="form-group"> 
    						<label for="image">Match 1 </label> 
    						<input type="text" class="form-control"  name="question" > 
    					
    					</div>
    				</div>    			
    			</div>
    			<div class="form-row">
    				<div class="col-md-12 mb-3">
    					<div class="form-group">
    						<label for="question">Match 2</label>
    						<textarea class="form-control"    rows="3" name="answer"></textarea>
    					</div>
    				</div>
    			</div>
				<div class="form-row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="image">Match 1 image</label>
                        <input type="file" class="form-control" id="image" name="image">
                        <label class="mt-1">{{__('Label.Note_Image')}}</label>
                    </div>
                </div> 
                <div class="col-md-6">
                    <div class="form-group">
                        <div class="custom-file ml-5">
                            <?php $app = URL::asset('/assets/imgs/1.png') ?>
                            <img src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
                        </div>
                    </div>
                </div>
            </div>
			<div class="form-row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="image">Match 2 image</label>
                        <input type="file" class="form-control" id="image1" name="image1">
                        <label class="mt-1">{{__('Label.Note_Image')}}</label>
                    </div>
                </div> 
                <div class="col-md-6">
                    <div class="form-group">
                        <div class="custom-file ml-5">
                            <?php $app = URL::asset('/assets/imgs/1.png') ?>
                            <img src="{{$app}}" height="120px" width="120px" class="mb-3" id="preview-image-before-upload">
                        </div>
                    </div>
                </div>
            </div>
				
				<div class="border-top mt-2 pt-3">
    				<button type="button" class="btn btn-default mw-120" onclick="save_pratice_question()">{{__('Label.SAVE')}}</button>
    				<a href="{{route('matchmaking', ['id'=>$id])}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
    			</div>
    		</form>
    	</div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')
	<script type="text/javascript">

		function save_pratice_question(){
			$("#dvloader").show();
			var formData = new FormData($("#save_pratice_question")[0]);
			$.ajax({
				type:'POST',
				url:'{{ route("matchmakingSave", ["id"=>$id]) }}',
				data:formData,
				cache:false,
				contentType: false,
				processData: false,
				success:function(resp){
					$("#dvloader").hide();
					get_responce_message(resp, 'save_pratice_question', '{{ route("matchmaking",["id"=>$id]) }}');
				},
				error: function(XMLHttpRequest, textStatus, errorThrown) {
					$("#dvloader").hide();
					toastr.error(errorThrown.msg,'failed');         
				}
			});
		}	
	
	</script>
			 
@endpush