
@extends('admin.layouts.master')
@section('title',  __('Faq'))
@section('content')
 
    <!-- Start: Body-Content -->
    <div class="body-content">
      <!-- mobile title -->
      <h1 class="page-title-sm">Faq</h1>

      <div class="border-bottom row mb-3">
        <div class="col-sm-10">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"> {{__('Label.Dashboard')}}</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">
              {{__('FAQ')}}
            </li>
          </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center" style="margin-top:-14px">
          <a href="{{ route('faqAdd') }}" class="btn btn-default mw-120">add FAQ</a>
        </div>
      </div>
      
      <div class="table-responsive">
        <table class="table table-striped category-table text-center table-bordered" id="your-datatable">
          <thead>
            <tr style="background: #F9FAFF;">
              <th> {{__('Label.Id')}} </th>              
              <th> Question </th>
              <th> Answer </th>
              <th> {{__('Label.Action')}} </th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
    <!-- End: Body-Content -->
  </div>
  <!-- End: Right Contenct -->
@endsection

@push('scripts')

  <script type="text/javascript">

    $(document).ready(function() {
      $(function () {
        var table = $('.category-table').DataTable({
          "responsive": true,
          "autoWidth": false,
          language: {
            paginate: {
              previous: "<img src='{{url('assets/imgs/left-arrow.png')}}' >",
              next: "<img src='{{url('assets/imgs/left-arrow.png')}}' style='transform: rotate(180deg)'>"
            }
          },
          lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, 'All'] ],
          processing: true,
          serverSide: false,
          order: [ [0, 'asc'] ],
          ajax: "{{ route('faqData') }}",
          columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
         
            {data: 'question', name:'question'},
            {data: 'answer', name:'answer'},
          
            {data: 'action', name: 'action', orderable: false, searchable: false},
          ],
        });
        
      });
    });
  </script>
  <script type="text/javascript">
  
    

  </script>

@endpush

