@extends('admin.layouts.master')
@section('title', __('Add FAQ'))
@section('content')

<!-- Start: Body-Content -->
<div class="body-content">
    <!-- mobile title -->
   

    <div class="border-bottom row mb-3">
        <div class="col-sm-10">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ route('dashboard') }}">{{__('Label.Dashboard')}}</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="{{ route('faq') }}">{{__('Faq')}}</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                Add  Faq
                </li>
            </ol>
        </div>
        <div class="col-sm-2 d-flex align-items-center">
            <a href="{{ route('faq') }}" class="btn btn-default mw-120"
                style="margin-top:-14px">FAQ</a>
        </div>
    </div>

    <div class="card custom-border-card mt-3">
        <form enctype="multipart/form-data" id="save_studyset">
            {!! csrf_field() !!}
            <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Question</label>
                        <input name="question" type="text" class="form-control" id="question"
                            placeholder="Question">
                    </div>
                </div>
            </div>
             
               
             

                <div class="form-row">
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="name">Answer</label>
                        <textarea name="answer"  rows=4 class="form-control" id="answer"
                            > </textarea>
                    </div>
                </div>
            </div>
          
          
          
             
            <div class="border-top pt-3">
                <button type="button" class="btn btn-default mw-120"
                    onclick="save_studyset()">{{__('Label.SAVE')}}</button>
                <a href="{{route('faq')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
            </div>
        </form>
    </div>
</div>
<!-- End: Body-Content -->
</div>
<!-- End: Right Contenct -->
@endsection

@push('scripts')
<script type="text/javascript">
    function save_studyset() {
        $("#dvloader").show();
        var formData = new FormData($("#save_studyset")[0]);
        $.ajax({
            type: 'POST',
            url: '{{ route("faqSave") }}',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success: function(resp) {
                $("#dvloader").hide();
                get_responce_message(resp, 'save_studyset', '{{ route("faq") }}');
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                $("#dvloader").hide();
                toastr.error(errorThrown.msg, 'failed');
            }
        });
    }
  
    $('.reward_type').on('change', function() {
  		if (this.value == 3) {
				$('.option_class').hide();
			} else {
				$('.option_class').show();
			}
});
    // $('.reward_type').on('click', function() {
	// 		var question_type = $('input[name=reward_type]:selected').val()
	// 		if (question_type == 3) {
	// 			$('.option_class').hide();
	// 		} else {
	// 			$('.option_class').show();
	// 		}
	// 	})
</script>
@endpush