<?php

namespace App\Http\Controllers\Admin;

use Validator;  
use App\Models\Level;
use DataTables, URL, DB;
use App\Models\StudySet;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Models\Classification;
use App\Models\Pratice_Question;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class PraticeQuestionController extends Controller
{

    private $folder = "/pratice_question";

    public function index($id)
    {
        try{
            $set=StudySet::where('id', $id)->first();
          
            return view('admin.pratice_question.index')->with(['id'=>$id,  'name'=>$set->name]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function add($id)
    {
        try{
            $set=StudySet::where('id', $id)->first();  
            
            $level = Level::select('*')->get();
      
            $category = Category::select('*')->get();
            $level = Level::select('*')->get();
            $classification = Classification::select('*')->get();

            return view('admin.pratice_question.add',[ 'name'=>$set->name, 'id'=> $id, 'category'=>$category, 'level'=>$level,'classification'=>$classification]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function save(Request $request, $id)
    {
        try{  if($request->question_type == 2){
            $validator = Validator::make($request->all(),[
              
                'question' => 'required',
                'term' => 'required',
                'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'question_type' => 'required',
                'option_a' => 'required',
                'option_b' => 'required',
                'answer' => 'required',
              
            ]);
        } else{
          
                $validator = Validator::make($request->all(),[
                   
                    'question' => 'required',
                    'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',                   
                    'option_a' => 'required',
                    'option_b' => 'required',
                    'option_c' => 'required',
                    'option_d' => 'required',
                    'answer' => 'required',
                   
                ]);
            }
            
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $question = new Pratice_Question();
                $question->question = $request->question;
                $question->term = $request->term;
                $question->question_type = $request->question_type;
                $question->studyset_id = $id;           
                $question->option_a = $request->option_a;
                $question->option_b = $request->option_b;
                if($request->question_type == 1){
                    $question->option_c = $request->option_c;
                    $question->option_d = $request->option_d;
                } else {
                    $question->option_c = "";
                    $question->option_d = "";
                }
                $question->answer = $request->answer;
                $question->note = $request->note;        

                $org_name = $request->file('image');
                if ($org_name) {
                    $question->image = saveImage($org_name,$this->folder);
                } 

                if($question->save()){
                    return response()->json(array('status' => 200, 'success'=> __('Label.success_add_question') ));
                } else {
                    return response()->json(array('status' => 400, 'errors'=> __('Label.error_add_question') ));
                }
            }
        } catch(Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function data(Request $request)
    {
        try{        
            if ($request==true) {
                $data = Pratice_Question::with('category')->with('studyset')->where('studyset_id',$request->id)
                        ->with('level')
                        ->get();
            
                return DataTables()::of($data)
                ->addIndexColumn()
                ->addColumn('question', function($row){
                  
                    return $row->question;
                })
                ->addColumn('action', function($row){
                    $btn = '<a href="'.route("editPraticequestion",["id"=>$row->id ,"setId"=>$row->studyset_id]).'" class="btn"><img src="'.url("assets/imgs/edit.png").'" /></a> ';
                    $btn .= '<a href="'.route("deletePraticequestion",$row->id).'" onclick="return confirm(\'Are you sure you want to delete this item\')" class="delete btn btn-sm"><img src="'.url("assets/imgs/trash.png").'" /></a>';
                    return $btn;
                })
                ->rawColumns(['action','question'])
                ->make(true);
            } else{     
                return view('admin.pratice_question.index');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function delete($id)
    {
        try{
          
           
            $question = Pratice_Question::where('id',$id)->first();
            if ($question->image !=null) {
               if($question->delete()){
                    @unlink("images/pratice_question/".$question->image);        
                    return back()->with('success', __('Label.Question Delete Successfully.'));   
                }
            } else {
                if($question->delete()){
                    return back()->with('success', __('Label.Question Delete Successfully.'));   
                }
            }
        } catch(Exception $e){
            return redirect('praticequestion')->with($e);
        }
    }
    public function edit(Request $request, $id , $setId)
    {
        try{
            $set=StudySet::where('id', $setId)->first();
            $question = Pratice_Question::where('id',$id)->first();
            $category = Category::select('*')->get();
            $level = Level::select('*')->get();
            $classification = Classification::select('*')->get();
            return view('admin.pratice_question.edit',['result'=>$question,
            'category'=>$category,
            'setId'=>$setId,
            'name'=>$set->name,
            'level'=>$level,
            'classification'=>$classification]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    public function update(Request $request)
    {
        try {
            if($request->question_type == 2){
                $validator = Validator::make($request->all(),[
                  
                    
                    'question' => 'required',
                    'term' => 'required',
                    'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'question_type' => 'required',
                    'option_a' => 'required',
                    'option_b' => 'required',
                    'answer' => 'required',
                   
                ]);
            } else {
             
                $validator = Validator::make($request->all(),[
                   
                    'question' => 'required',
                    'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',                  
                    'option_a' => 'required',
                    'option_b' => 'required',
                    'option_c' => 'required',
                    'option_d' => 'required',
                    'answer' => 'required',
                  
                ]);
            }
            
            if($validator->fails()){
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors'=> $errs ));
            } else {
                $question = Pratice_Question::where('id',$request->id)->first();

                if (isset($question->id)) {            
                  
                
                    $question->question =$request->question;
                    $question->term =$request->term;
                    $question->studyset_id = $question->studyset_id;
                    $question->option_a = $request->option_a;
                    $question->option_b = $request->option_b;
                    $question->question_type = $request->question_type;
                    if($request->question_type == 2){
                        $question->option_c = "";
                        $question->option_d = "";
                    }else {
                        $question->option_c = $request->option_c;
                        $question->option_d = $request->option_d;
                    }
                    $question->answer = $request->answer;
                    $question->note = $request->note;

                    $org_name = $request->file('image');
                    if ($org_name) {
                        $question->image = saveImage($org_name,$this->folder);
                        @unlink("images/pratice_question/".$request->old_image);         
                    } else {
                        $question->image = $request->old_image;                    
                    }

                    if($question->save()) {
                        return response()->json(array('status' => 200, 'success'=>  __('Label.success_edit_question') ));
                    } else {
                        return response()->json(array('status' => 400, 'errors'=>  __('Label.error_edit_question') ));
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors'=> $e->getMessage() ));
        }
    }
    
}
